# WordPress REST API Guide (Advanced)

## 1) Base URL and routes
- Base site URL: `https://example.com`
- REST base: `https://example.com/wp-json/wp/v2`

## 2) Auth options
- Application Passwords (recommended for server-to-server).
- JWT (if enabled by plugin).
- Basic auth token in `Authorization` header.

## 3) Core endpoints
### Posts
- List: `GET /posts`
- Get: `GET /posts/{id}`
- Create: `POST /posts`
- Update: `POST /posts/{id}`
- Delete: `DELETE /posts/{id}`

Common fields:
- `title`, `content`, `excerpt`
- `status` (draft, publish, pending, private)
- `slug`, `date`, `author`
- `categories` (array of IDs), `tags` (array of IDs)

### Pages
- List: `GET /pages`
- Get: `GET /pages/{id}`
- Create: `POST /pages`
- Update: `POST /pages/{id}`
- Delete: `DELETE /pages/{id}`

### Categories
- List: `GET /categories`
- Create: `POST /categories`

Common fields:
- `name`, `slug`, `description`, `parent`

### Tags
- List: `GET /tags`
- Create: `POST /tags`

Common fields:
- `name`, `slug`, `description`

### Users (read-only by default)
- List: `GET /users`
- Get: `GET /users/{id}`

Common query params:
- `per_page`, `page`, `search`, `context`

## 4) Query parameters (high impact)
- `per_page`, `page` (pagination)
- `search` (keyword search)
- `context` (view, edit, embed)
- `status` (for posts/pages)
- `categories`, `tags` (filter by IDs)

## 5) Write patterns (JSON body)
### Create post
```json
{
  "title": "New post",
  "content": "Hello",
  "status": "draft",
  "categories": [3],
  "tags": [7]
}
```

### Update post
```json
{
  "title": "Updated title",
  "status": "publish"
}
```

## 6) Reliability notes
- Retry `429` and transient `5xx` errors with exponential backoff.
- Keep payloads small and avoid large HTML blobs in a single request.

## 7) Security notes
- Always use HTTPS.
- Use a dedicated low-privilege WordPress account for the bot.
