## Description
Brief description of changes made.

## Related Issue
Fixes #(issue number)

## Type of Change
- [ ] Bug fix (non-breaking change that fixes an issue)
- [ ] New feature (non-breaking change that adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Code refactoring
- [ ] Test improvement

## Changes Made
- 
- 
- 

## Testing Performed
- [ ] Ran `pytest` and all tests pass
- [ ] Ran `black --check` for code formatting
- [ ] Ran `flake8` for linting
- [ ] Tested manually against a WordPress site
- [ ] Added tests for new functionality

## Gutenberg Block Changes
If this PR adds or modifies Gutenberg block support:
- [ ] Added block documentation to `references/gutenberg-blocks.md`
- [ ] Added conversion logic to `content_to_gutenberg.py`
- [ ] Added tests for the new block
- [ ] Verified block renders correctly in WordPress

## Checklist
- [ ] My code follows the project's style guidelines
- [ ] I have added/updated docstrings for new functions
- [ ] I have updated the README if needed
- [ ] I have added a CHANGELOG entry under `[Unreleased]`
- [ ] My changes generate no new warnings

## Screenshots (if applicable)
Add screenshots showing the changes if relevant.

## Additional Notes
Any additional information or context.
