---
name: wordpress-mcp
description: Manage WordPress sites via MCP (Model Context Protocol) through AI Engine. Use for creating/editing posts, SEO analysis, analytics, media management, taxonomy operations, social media scheduling, multilingual content (Polylang), and any WordPress admin task. Requires AI Engine plugin (free) with MCP Server enabled. Also use when asked about WordPress site management, content workflows, or WP-related tasks.
---

# WordPress MCP

Manage WordPress sites through AI Engine's MCP Server. AI Engine is a free WordPress plugin that exposes a comprehensive MCP interface.

## Setup

The user needs:
1. **AI Engine** plugin installed (free: https://wordpress.org/plugins/ai-engine/)
2. MCP Server enabled in AI Engine → Settings → MCP
3. A **Bearer Token** set in MCP settings

Connection details should be stored in the user's `TOOLS.md`:
```
## WordPress MCP
- **URL:** https://example.com/wp-json/mcp/v1/http
- **Bearer Token:** <token from AI Engine MCP settings>
```

## How to Call MCP Tools

All calls use JSON-RPC 2.0 over HTTP POST:

```bash
curl -s -X POST <MCP_URL> \
  -H "Authorization: Bearer <TOKEN>" \
  -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"<tool_name>","arguments":{...}}}'
```

### Discovery

List available tools (varies by enabled features):
```json
{"jsonrpc":"2.0","id":1,"method":"tools/list"}
```

Always start with `tools/list` to discover what's enabled on this site.

### Connectivity Check
```json
{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"mcp_ping","arguments":{}}}
```

## MCP Features (Modular)

Tools are grouped into features that the site admin enables in AI Engine → Settings → MCP Features. **Only WordPress core is enabled by default.** Always use `tools/list` to discover what's available.

| Feature | Default | Description |
|---------|---------|-------------|
| **WordPress** | ✅ On | Posts, pages, comments, users, media, taxonomies, settings |
| **Plugins** | Off | Install, activate, update, and modify plugins |
| **Themes** | Off | Install, activate, switch, and customize themes |
| **Database** | Off | Execute SQL queries on the WordPress database |
| **Polylang** | Off | Multilingual content (requires Polylang plugin) |
| **WooCommerce** | Off | Products, orders, customers (requires WooCommerce) |
| **SEO Engine** | Off | SEO analysis, analytics (requires SEO Engine plugin) |
| **Social Engine** | Off | Social media scheduling (requires Social Engine plugin) |
| **Dynamic REST** | Off | Raw access to WordPress REST API |

See `references/features.md` for tool details per feature.

## Common Workflows

### Content Audit (WordPress + SEO Engine)
1. `mwseo_get_seo_statistics` — Overall site health
2. `mwseo_get_posts_needing_seo` — Posts with SEO problems
3. Loop: `mwseo_do_seo_scan` per post → fix with `mwseo_set_seo_title`, `mwseo_set_seo_excerpt`

### Publish a Post (WordPress core)
1. `wp_create_post` with `post_title`, `post_content`, `post_status: "draft"`
2. Optionally set SEO metadata if SEO Engine is enabled
3. `wp_update_post` with `post_status: "publish"` when ready

### Translation Workflow (Polylang)
1. `pll_translation_status` — See coverage gaps
2. `pll_get_posts_missing_translation` with target language
3. `pll_create_translation` — Create translated post linked to original

### Multi-Site Management
Store multiple sites in `TOOLS.md` and select by name:
```
### My Blog
- **URL:** https://blog.example.com/wp-json/mcp/v1/http
- **Token:** abc123

### My Shop
- **URL:** https://shop.example.com/wp-json/mcp/v1/http
- **Token:** xyz789
```

## Tips

- Use `wp_get_post_snapshot` instead of multiple calls — gets post + meta + terms in one request
- Use `wp_alter_post` for search-replace edits instead of re-uploading entire content
- `wp_get_posts` returns no full content by default — use `wp_get_post` for content
- Analytics date params use `start_date` / `end_date` (not camelCase)
- Always run `tools/list` first — available tools depend on which features the admin enabled
