---
name: WIP.file-guard
version: 1.0.1
description: Hook that blocks destructive edits to protected identity files. For Claude Code CLI and OpenClaw.
homepage: https://github.com/wipcomputer/wip-file-guard
metadata:
  category: dev-tools
  capabilities:
    - file-protection
    - edit-blocking
    - identity-guard
  dependencies: []
  interface: Claude Code Hook
  requires:
    binaries: [node]
openclaw:
  emoji: "🛡️"
  install:
    env: []
author:
  name: Parker Todd Brooks
---

# wip-file-guard

Hook that blocks destructive edits to protected identity files. For Claude Code CLI and OpenClaw.

## When to Use This Skill

**Use wip-file-guard for:**
- Protecting CLAUDE.md, SOUL.md, IDENTITY.md, MEMORY.md, and other identity files from being overwritten
- Blocking AI agents from replacing file content instead of extending it
- Surviving context compaction (behavioral rules get erased, but hooks don't)

**This is a technical guardrail, not a prompt.** It blocks the operation before it happens.

### Do NOT Use For

- Protecting binary files or images
- Blocking all edits (it allows small edits, only blocks destructive ones)
- Repos without identity files

## How It Works

Two rules:

1. **Write is blocked** on protected files. Always. Use Edit instead.
2. **Edit is blocked** when it removes more than 2 net lines from a protected file.

### Protected Files

CLAUDE.md, SHARED-CONTEXT.md, SOUL.md, IDENTITY.md, CONTEXT.md, TOOLS.md, MEMORY.md

### Protected Patterns

Any file matching: memory, memories, journal, diary, daily log

## API Reference

### CLI

```bash
node guard.mjs --list          # list protected files
bash test.sh                   # run test suite
```

### Claude Code Hook

Add to `~/.claude/settings.json`:

```json
{
  "hooks": {
    "PreToolUse": [
      {
        "matcher": "Edit|Write",
        "hooks": [
          {
            "type": "command",
            "command": "node \"/path/to/wip-file-guard/guard.mjs\"",
            "timeout": 5
          }
        ]
      }
    ]
  }
}
```

## Troubleshooting

### Agent keeps trying to Write

The deny message tells the agent to re-read the file and use Edit instead. If the agent ignores it, it's likely post-compaction and has lost context. The hook will keep blocking.

### Edit blocked unexpectedly

Check the net line removal. Edits that remove more than 2 lines from a protected file are blocked. Small edits (adding or replacing 1-2 lines) are allowed.
