---
name: Wiki
description: "Build wikis people actually read — structure pages, cross-link, and keep content fresh."
emoji: 📚
os: all
tags: [documentation, knowledge-base, content-management]
author: ClawHub
version: 1.0
---

# Wiki Creation and Maintenance

## Page Structure Requirements

- **Every page needs:** clear title, one-sentence summary, last-updated date
- **Use consistent templates** across all pages (same sections, same order)
- **Keep pages focused:** one topic per page, split when exceeding ~500 words
- **Include Getting Started page** that maps the entire wiki structure

## Writing Guidelines

- **Write for zero-context readers** — never assume prior knowledge
- **Write procedures as numbered steps,** not paragraphs
- **Include examples and diagrams** wherever possible — wikis without examples are just glossaries
- **Mark uncertain content explicitly** — use "[needs verification]" or "[outdated]" tags

## Linking and Organization

- **Cross-link aggressively** — every mention of another concept should link to its page
- **Use categories/tags** for discoverability beyond the link graph
- **Create redirect pages** when renaming — never break existing links
- **Maintain link integrity** when restructuring content

## Content Maintenance

- **When updating information,** update ALL pages that reference it (grep for mentions)
- **Maintain a changelog** or "recently updated" page for team visibility
- **Regular content audits** — mark outdated information before it misleads
- **Enforce consistent formatting** across all contributors

## Quality Control

- **Review new pages** for template compliance and link accuracy
- **Periodic cleanup** of orphaned pages and broken internal links
- **Version control** for tracking changes and reverting mistakes
- **Backup strategy** for content preservation and disaster recovery

## Success Metrics

- **Easy navigation** — users can find information in <3 clicks
- **Self-contained pages** — each page answers its topic completely
- **Fresh content** — regular updates keep information current and valuable