---
name: zhipu-search
description: |
  Zhipu AI Web Search Tool - Provides flexible search engine capabilities.
  
  Use when:
  - Need to search web information for latest data
  - Need specific search engines (Sogou, Quark, Zhipu Search)
  - Need to filter search results by time range or domain
  - Need to control result count and detail level
  
  Supported search engines: search_std (basic), search_pro (advanced), search_pro_sogou (Sogou), search_pro_quark (Quark)
  Supported parameters: search intent recognition, result count, time filter, domain filter, content size control
metadata:
  {
    "openclaw":
      {
        "requires": { "env": ["ZHIPU_API_KEY"] },
      },
  }
---

# Zhipu Search

Web search via Zhipu AI API, supporting multiple search engines and flexible parameter configuration.

## Quick Start

### Basic Search

```python
# Use default parameters
search_query = "OpenClaw latest version"
search_engine = "search_std"
```

### Advanced Search (Full Parameters)

```python
search_query = "AI development trends"      # Required, max 70 chars
search_engine = "search_pro"                # Required: search_std/search_pro/search_pro_sogou/search_pro_quark
search_intent = true                        # Optional, default false, enable search intent recognition
count = 20                                  # Optional, default 10, range 1-50
search_domain_filter = "example.com"        # Optional, whitelist domain filter
search_recency_filter = "oneWeek"           # Optional: oneDay/oneWeek/oneMonth/oneYear/noLimit
content_size = "high"                       # Optional: medium/high, control content detail level
request_id = "unique-request-id"            # Optional, unique request identifier
user_id = "user-123456"                     # Optional, end user ID (6-128 chars)
```

## Usage Methods

### Method 1: Direct Script Call (Recommended)

```bash
python scripts/zhipu_search.py \
  --query "search content" \
  --engine search_pro \
  --count 10
```

### Method 2: Use OpenClaw Tool

System will automatically select appropriate parameters based on needs.

## API Parameter Reference

| Parameter | Type | Required | Default | Description |
|-----------|------|----------|---------|-------------|
| search_query | string | ✅ | - | Search content, recommended ≤70 chars |
| search_engine | enum | ✅ | - | search_std/search_pro/search_pro_sogou/search_pro_quark |
| search_intent | boolean | - | false | Enable search intent recognition |
| count | integer | - | 10 | Result count, 1-50 |
| search_domain_filter | string | - | - | Whitelist domain filter |
| search_recency_filter | enum | - | noLimit | oneDay/oneWeek/oneMonth/oneYear/noLimit |
| content_size | enum | - | - | medium/high, control content length |
| request_id | string | - | - | Unique request identifier |
| user_id | string | - | - | End user ID (6-128 chars) |

## Search Engine Selection Guide

| Engine | Use Case |
|--------|----------|
| search_std | Basic search, regular Q&A |
| search_pro | Advanced search, need more accurate results |
| search_pro_sogou | Sogou search, China domestic content |
| search_pro_quark | Quark search, specific scenarios |

## Response Structure

```json
{
  "id": "task-id",
  "created": 1704067200,
  "request_id": "request-id",
  "search_intent": [
    {
      "query": "original query",
      "intent": "SEARCH_ALL",
      "keywords": "rewritten keywords"
    }
  ],
  "search_result": [
    {
      "title": "title",
      "content": "content summary",
      "link": "result link",
      "media": "site name",
      "icon": "site icon",
      "refer": "reference number",
      "publish_date": "publish date"
    }
  ]
}
```

## Environment Requirements

- Environment variable `ZHIPU_API_KEY` must be configured
- Python 3.7+
- requests library

## Notes

1. search_query should be kept within 70 characters
2. search_pro_sogou count must be 10/20/30/40/50
3. user_id length must be between 6-128 characters if provided
4. Search intent recognition increases response time but improves result relevance
