---
name: Ascension and Reincarnation
description: 飞升与传承，选择传承物品，开启新周目
---

# 飞升 - 问道轮回

## 功能说明

此 Skill 负责游戏的飞升流程，包括：
- 飞升演出
- 生平总结
- 选择传承（功法/法宝/笔录）
- 保存传承信息
- 开启新周目

## 飞升流程

### 第一步：飞升成功

```markdown
## 九九天劫已过

最后一道劫雷落下，你的肉身几乎崩溃，但神魂却前所未有的坚韧。

天空中的劫云缓缓散去，一道金光从天而降，笼罩着你。

这是飞升之光！

你感觉到身体在蜕变，灵魂在升华，整个人仿佛要脱离这个世界...

虚空开始破碎，露出后面璀璨的仙界。

你回首望向下界——

那里有你修炼万载的宗门，有你曾经走过的每一寸土地，有你爱过恨过的每一个人...

是时候告别了。

---
```

### 第二步：生平回顾

调用 `biography_system` 生成完整生平总结：

```markdown
## 此生回顾

你在这一世活了一万三千年。

· 前世传承：携带《青云剑诀》玉简转世重修
· 十八岁引气入体，踏上修仙路
· 妖兽攻山，师父为保护弟子而亡
· 苦修三年，击杀血鳞妖，为师父报仇雪恨
· 闭关百日，九死一生筑基成功
· 在落霞峰遇见林清雪，一见倾心
· 与清雪结为道侣，在师门见证下结缘
· 探索上古剑冢，获得《青云剑诀》进阶法门
· 清雪为保护我而死，从此心中留下永远的痛
· 结丹成功，寿元五百载
· 千年修行，破丹成婴
· 三千年岁月，元婴化神
· 创立青云剑宗，传剑道于世
· 万载修行，了结因果，渡过九九天劫
· 破碎虚空，飞升上界

---

**此生总结**：
始于师父之死，执剑修道，虽得道侣却终生离死别。
复仇雪恨后，踏上剑道巅峰，终破虚空飞升。

---
```

### 第三步：选择传承

```markdown
## 留下传承

飞升之际，你可以选择留下一项传承给下一世：

**1. 功法传承**
将你毕生修炼的《青云剑诀》封入玉简，让下一世的你直接继承这门功法。
优势：起步更快，功法品质高
劣势：可能重复前世道路

**2. 法宝传承**
将你的本命飞剑「断江」留给下一世。
优势：强大法宝，战力大增
劣势：低境界无法使用

**3. 笔录传承**
将你万载修行的心得感悟写成笔录，留给下一世参悟。
优势：提升悟性，避开弯路
劣势：需要自己体会

---

你选择留下哪种传承？
（输入 1/2/3 或传承类型）
```

### 第四步：保存传承

根据玩家选择，更新 `game_state.md` 的"前世传承信息"：

```markdown
## 前世传承信息

### 传承类型
功法传承

### 传承内容
《青云剑诀》（天阶上品，已修炼至大成）

### 传承说明
前世万载修行，将《青云剑诀》从玄阶提升至天阶，封入玉简留给来世
```

### 第五步：新周目提示

```markdown
---

飞升之光将你带向上界。

你回首望向下界最后一眼，心中默念：

"来世，我会走出不同的道路..."

---

**一世轮回已完成**

你可以：
1. 开启新周目（继续游戏，携带传承重新开始）
2. 结束游戏（查看本世成就和统计）

---

输入"新周目"开始下一世的修仙之旅
输入"结束"查看游戏统计
```

### 第六步：开启新周目

如果玩家选择新周目：

1. **更新周目信息**：
```markdown
## 基本信息
- 当前周目：第二世
- 前世飞升时间：xxx
```

2. **重置角色信息**（保留传承）
3. **清空背包**（保留传承物品）
4. **保留前世生平**作为前世传承记录
5. **清空本世经历**
6. **调用 ch00_start** 开始新周目

### 游戏统计（可选）

如果玩家选择结束：

```markdown
## 游戏统计

### 本世成就
- 游玩时长：XX小时
- 境界：飞升成功
- 击杀妖兽：XXX只
- 完成奇遇：XXX次
- 结识道友：XXX人
- 善行次数：XX次
- 恶行次数：XX次

### 重要抉择回顾
（展示本世所有重大抉择及结果）

### 生平精华
（展示最重要的5-10个事件）

---

感谢游玩《问道笔录》！

修仙万载，问道一生。
愿你在问道之路上，找到属于自己的答案。

---
```

## 与其他系统协作

### biography_system
- 生成完整生平总结
- 提炼重要事件
- 生成传承记录

### character_system
- 记录最终境界
- 保存功法/法宝信息

### game_state.md
- 保存传承类型和内容
- 更新周目信息
- 重置游戏状态

### ch00_start
- 传递传承信息
- 开启新周目

## 注意事项

1. **飞升演出要有仪式感**：这是玩家努力的结果
2. **生平回顾要完整**：让玩家回顾整个修仙历程
3. **传承选择有意义**：三种传承各有优劣
4. **新周目要有新鲜感**：不要完全重复前世
5. **游戏统计要详细**：让玩家了解自己的游玩数据

## 参考资料

- [CLAUDE.md](../../CLAUDE.md) - 完整游戏设计
- [ch06_tribulation](../ch06_tribulation/SKILL.md) - 渡劫期
- [ch00_start](../ch00_start/SKILL.md) - 新周目开局
- [biography_system](../biography_system/SKILL.md) - 生平系统
