---
name: cultivation-chronicle
description: 问道笔录 - 修仙文字冒险游戏。玩家从凡人开始修炼，经历炼气、筑基、金丹、元婴、化神、渡劫、飞升七大境界，通过选择塑造道心，最终成就修仙之路。支持转世传承、角色成长、物品系统。适用于修仙题材、角色扮演、文字冒险等场景。
---

# 问道笔录 ⚔️

一个深度沉浸式的修仙文字冒险游戏。从凡人起步，一路修炼至飞升，每个选择都影响你的道心与命运。

## 游戏简介

**核心理念：**
> 修仙万载，问道一生

这不仅是一场修炼之旅，更是一次关于道心、选择和成长的探索。

**游戏特色：**
- 📖 完整的修仙体系（7大境界）
- 🔄 转世传承系统（前世记忆和物品）
- 💭 道心系统（选择影响性格和结局）
- 🎒 物品和装备系统
- 📜 生平自传记录
- 🌟 多样化的修炼路径

## 七大修炼境界

游戏涵盖完整的修仙境界体系：

### 1. 炼气期 (Qi Refining)
**引气入体，筑基之前**
- 文件：`ch01_qi_refining.md`
- 重点：初入仙途，学习基础功法
- 挑战：资源匮乏，天赋测试
- 时长：约 10-20 年修炼

### 2. 筑基期 (Foundation Building)
**夯实根基，踏入修真**
- 文件：`ch02_foundation.md`
- 重点：筑基成功，正式踏入修仙之路
- 挑战：筑基瓶颈，门派试炼
- 时长：约 50-100 年

### 3. 金丹期 (Golden Core)
**凝聚金丹，初窥长生**
- 文件：`ch03_golden_core.md`
- 重点：凝聚金丹，寿元大增
- 挑战：结丹之劫，心魔考验
- 时长：约 500 年

### 4. 元婴期 (Nascent Soul)
**元婴出窍，神魂合一**
- 文件：`ch04_nascent_soul.md`
- 重点：孕育元婴，神通大成
- 挑战：天劫降临，生死考验
- 时长：约 1000 年

### 5. 化神期 (Spirit Transformation)
**化神通天，掌控法则**
- 文件：`ch05_spirit_transformation.md`
- 重点：化神成功，掌握法则之力
- 挑战：感悟天道，抉择道路
- 时长：约 5000 年

### 6. 渡劫期 (Tribulation)
**九九天劫，生死一线**
- 文件：`ch06_tribulation.md`
- 重点：面对九九天劫的终极考验
- 挑战：天劫之力，道心磨砺
- 时长：视准备而定

### 7. 飞升期 (Ascension)
**羽化飞升，超脱三界**
- 文件：`ch07_ascension.md`
- 重点：飞升仙界，完成终极目标
- 意义：游戏终结，成就飞升

## 三大核心系统

游戏依赖三大系统管理游戏状态（位于 `references/`）：

### 1. 角色系统 (Character System)
- 文件：`system_character_system.md`
- 管理：境界、修为、属性、天赋
- 记录：灵根、道心、功法、神通

### 2. 背包系统 (Inventory System)
- 文件：`system_inventory_system.md`
- 管理：法宝、丹药、灵石、材料
- 功能：物品获取、使用、炼制

### 3. 生平系统 (Biography System)
- 文件：`system_biography_system.md`
- 记录：人生大事、重要选择、感悟
- 传承：转世时继承部分记忆和物品

## 使用方法

### 开始新游戏

1. **读取系统文件**（了解游戏机制）：
```
read references/system_character_system.md
read references/system_inventory_system.md
read references/system_biography_system.md
```

2. **启动游戏开局**：
```
read references/ch00_start.md
```

3. **按照指引创建角色**，初始化系统

### 推进修炼

根据当前境界，读取对应章节文件：

```
read references/ch01_qi_refining.md      # 炼气期
read references/ch02_foundation.md       # 筑基期
read references/ch03_golden_core.md      # 金丹期
```

以此类推，直至飞升。

### 境界突破

每个境界都有：
- **日常修炼**：积累修为，学习功法
- **突破契机**：完成关键任务或感悟
- **境界之劫**：突破时的考验（越高越难）
- **境界成就**：成功后获得新能力

## 核心游戏机制

### 1. 道心系统
你的每个选择都会影响道心倾向：
- **剑修之道** - 一往无前，杀伐果断
- **丹修之道** - 济世救人，炼丹成道
- **阵修之道** - 精研阵法，守护一方
- **散修之道** - 逍遥自在，不拘一格
- **魔修之道** - 不择手段，以力证道

道心影响：
- 可学习的功法和神通
- NPC 对你的态度
- 某些剧情的走向
- 最终的飞升方式

### 2. 转世传承
当角色死亡或重新开始时：
- **前世记忆**：部分重要经历保留
- **传承物品**：最多 3 件物品可带入新生
- **道心延续**：部分道心倾向继承
- **天赋加成**：前世成就可能带来天赋

### 3. 修炼路径
不同的选择导向不同的修炼路径：
- **正道修士**：加入名门正派
- **散修独行**：独自闯荡修仙界
- **魔道修士**：追求极致力量
- **隐世修炼**：专注闭关突破
- **游历天下**：历练中成长

### 4. 资源管理
修炼需要各种资源：
- 💎 **灵石**：修炼货币
- 💊 **丹药**：辅助修炼和疗伤
- 📖 **功法**：提升修炼速度
- ⚔️ **法宝**：战斗和护身
- 🌿 **灵材**：炼丹炼器材料

## 游戏开局流程

### 第一步：检查传承
系统检查是否有前世传承：
- 有传承 → 继承记忆和物品
- 无传承 → 全新开始

### 第二步：创建角色
设定基本信息：
- 姓名（自定义或随机）
- 性别（男/女/自定义）
- 年龄（通常从16岁开始）

### 第三步：测试灵根
随机或选择你的灵根：
- **单灵根**：天才，但稀有（金/木/水/火/土）
- **双灵根**：优秀
- **三灵根**：普通
- **四灵根/五灵根**：困难，但可能另有奇遇
- **特殊灵根**：雷/冰/风等变异灵根

### 第四步：进入炼气期
开始第一境界的修炼之路

## 叙事风格

### 修仙特色
- 使用修仙术语（道友、天劫、灵气等）
- 时间跨度长（数十年、数百年）
- 层次分明（低阶/中阶/高阶修士）
- 因果报应（善恶有报，天道轮回）

### 互动方式
- 每个境界分多个阶段（初期/中期/后期/大圆满）
- 重要抉择影响剧情走向
- 随机事件增加可玩性
- 自由探索与主线并重

## 常见修仙词汇

- **道友** - 对其他修士的尊称
- **天道** - 世界规则和法则
- **灵气** - 修炼的基础能量
- **天劫** - 突破境界时的雷劫
- **心魔** - 修炼中的心理障碍
- **飞升** - 成仙，离开凡界
- **仙缘** - 修仙机遇
- **洞府** - 修士的居所
- **法宝** - 修士使用的法器
- **神通** - 境界提升后的特殊能力

## 注意事项

1. **时间跨度** - 修仙是漫长的，动辄数十年
2. **资源管理** - 合理分配灵石和资源
3. **道心一致** - 保持选择的连贯性
4. **劫数考验** - 每次突破都有风险
5. **因果循环** - 你的选择会有后果

## 开始问道

准备好开启你的修仙之路了吗？

```
read references/ch00_start.md
```

⚔️ 愿你道心坚定，早日飞升！
