# 출력 템플릿

> 공통 Flash/Deep-Dive 구조: [`../../common/output_templates_base.md`](../../common/output_templates_base.md)

---

## Birth Support (출산 지원) Flash — 가장 수요 높은 템플릿

```markdown
### 🍀 출산 지원 총정리 (YYYY년 기준)

**임신 중**
| 지원 | 금액/내용 | 조건 |
|------|---------|------|
| 임신·출산 진료비 (국민행복카드) | 100만원 (다태아 140만원) | 건강보험 가입자 |
| 엽산제·철분제 | 무료 지급 | 보건소 신청 |
| 산전검사 | 무료 (보건소) | 임산부 |

**출산 직후 (출생 후 1년 이내 신청 권장)**
| 지원 | 금액/내용 | 조건 |
|------|---------|------|
| 첫만남이용권 | 200만원 (첫째·이상 동일, 2024년~) | 출생 아동 전체 |
| 부모급여 | 0세: 월 100만원 / 1세: 월 50만원 | 가정 양육 |
| 아동수당 | 월 10만원 (만 8세 미만) | 소득 무관 |
| 영아수당(보육료) | 어린이집 이용 시 보육료 전액 지원 | 0~2세 |

**지자체 추가 지원 (지역별 상이)**
- 출생축하금: 지역마다 10만원~최대 수천만원까지 차이
- [지역] 주민센터 또는 복지로에서 확인 권장

**신청 방법**
- 온라인: [정부24](https://www.gov.kr) → "출산" 검색
- 방문: 주민센터 (출산 후 1개월 내 방문 시 한번에 통합 신청 가능)
- 전화: 129 (보건복지부 콜센터)

⚠️ 2025년 이후 정책 변경 가능. 정확한 금액은 복지로(www.bokjiro.go.kr) 확인.
```

---

## Childcare (육아 지원) Flash

```markdown
### 🍀 연령별 육아 지원 (YYYY년 기준)

| 나이 | 지원 종류 | 금액/내용 |
|------|---------|---------|
| 0세 | 부모급여 | 월 100만원 (가정 양육) |
| 0세 | 보육료 지원 | 어린이집 이용 시 전액 |
| 1세 | 부모급여 | 월 50만원 (가정 양육) |
| 1세 | 보육료 지원 | 어린이집 이용 시 전액 |
| 2세 | 보육료 지원 | 어린이집 이용 시 전액 |
| 3~5세 | 유아학비/보육료 | 유치원·어린이집 지원 |
| 0~7세 | 아동수당 | 월 10만원 |

**부모급여 vs 보육료: 선택 불가 (이용 방식에 따라 자동 결정)**
- 가정 양육 → 부모급여 현금
- 어린이집 이용 → 보육료 바우처
```

---

## Basic Living (기초생활수급) Flash

```markdown
### 🍀 기초생활보장 급여 (YYYY년 기준)

**선정 기준 (중위소득 %, 4인 가구 기준)**
| 급여 종류 | 선정 기준 | 지원 내용 |
|---------|---------|---------|
| 생계급여 | 중위소득 32% 이하 | 최저 생계비 현금 지급 |
| 의료급여 | 중위소득 40% 이하 | 의료비 거의 무료 |
| 주거급여 | 중위소득 48% 이하 | 임차료 지원 또는 수선비 |
| 교육급여 | 중위소득 50% 이하 | 교육활동비·교과서 지원 |

**2025년 중위소득 기준 (4인 가구)**
- 100%: 약 572만원/월
- 50%: 약 286만원/월
- 32%: 약 183만원/월

**신청**
→ 주민센터 방문 또는 복지로(www.bokjiro.go.kr) 온라인 신청

⚠️ 재산·부양의무자 기준 적용. 정확한 판정은 담당 공무원 확인 필요.
```

---

## Benefit Search Deep-Dive

```markdown
## 맞춤 혜택 조회 결과 — [조건: 나이/지역/상황]

### 중앙 정부 지원
| 지원명 | 대상 | 금액 | 신청 |
|--------|------|------|------|
| … | … | … | … |

### [지역] 지자체 추가 지원
| 지원명 | 대상 | 금액 | 신청 |
|--------|------|------|------|
| … | … | … | … |

### 신청 우선순위
1. [즉시 신청 가능, 기한 임박]
2. [놓치기 쉬운 지원]
3. [장기 유지 지원]

⚠️ YYYY년 기준. 정책 변경 가능. 복지로·주민센터 최종 확인 권장.
```

---

## 초보자 모드 용어 설명
`domain_config.yaml > beginner_mode > glossary` 참조.
