# 육아/복지 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## Phase 1: 인텐트 분류 & 파라미터 수집

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **조건 수집** (Benefit Search / Childcare / Birth Support 시):
   ```
   "맞춤 혜택을 찾으려면 몇 가지 여쭤볼게요:
   - 나이/자녀 나이:
   - 거주 지역 (시/군/구):
   - 가구원 수 (선택):
   - 소득 수준 (선택: 중위소득 몇% 이하 예상?)"
   ```
3. 조건 없으면 일반 안내 + "조건 알려주시면 맞춤형 조회 가능" 안내

---

## Phase 2: 데이터 수집

### 2-1. 복지로 중앙부처 API (조건 필터링)
```bash
# 키 활성화 후 사용
# bash skills/welfare-guide/scripts/welfare_central.sh "[대상코드]" "[지역코드]"
```
- 대상 코드: 영유아(001), 아동(002), 청소년(003), 청년(004), 중장년(005), 노인(006), 장애인(007), 임산부(008), 다문화(009), 저소득(010)

### 2-2. 보조금24 API (포괄 조회)
```bash
# 키 활성화 후 사용
# bash skills/welfare-guide/scripts/subsidy24.sh "[검색어]"
```

### 2-3. 복지로 지자체 API (지역 특화)
```bash
# 키 활성화 후 사용
# bash skills/welfare-guide/scripts/welfare_local.sh "[시도코드]" "[시군구코드]"
```

### 2-4. 웹 검색 보강 (API 미활성 기간 대체)
```
web_search: "[상황] 지원금 2026 복지로"
web_search: "[지역] 출산지원금 2026"
web_search: "기초생활수급 선정기준 2025"
```

---

## Phase 3: 핵심 레퍼런스

### 2025년 주요 지원 현황

**출산·육아 핵심 (2024년~)**
| 지원 | 금액 | 대상 |
|------|------|------|
| 첫만남이용권 | 200만원 (둘째↑ 300만원) | 출생 아동 전체 |
| 부모급여 | 0세 100만/월, 1세 50만/월 | 가정 양육 |
| 아동수당 | 10만원/월 | 만 8세 미만 |
| 임신·출산 진료비 | 100만원 바우처 | 임산부 |

**청년 주요 지원**
| 지원 | 내용 | 대상 |
|------|------|------|
| 청년도약계좌 | 월 40~70만원 납입 → 5년 후 최대 5천만원 | 만 19~34세, 소득 6천만원↓ |
| 청년 주거급여 분리지급 | 주거급여 별도 지급 | 19~30세 미만, 독립 거주 |
| 국민취업지원제도 | 구직촉진수당 월 50만원 × 6개월 | 취업 취약 청년 |

**노인 주요 지원**
| 지원 | 내용 | 대상 |
|------|------|------|
| 기초연금 | 월 최대 33만원 (단독) | 만 65세↑, 소득하위 70% |
| 노인장기요양보험 | 재가·시설 서비스 지원 | 65세↑ 또는 노인성 질환자 |
| 노인일자리 | 월 27만~59만원 | 65세↑ |

**장애인 주요 지원**
| 지원 | 내용 | 대상 |
|------|------|------|
| 장애인연금 | 월 최대 40만원 | 중증(1~2급), 소득하위 70% |
| 장애수당 | 월 6만원 | 경증(3~6급), 기초/차상위 |
| 활동지원서비스 | 활동보조인 파견 | 1~3급 장애인 |

### 기초생활보장 중위소득 기준 (2025년)
| 가구원 수 | 100% | 50% | 48% | 40% | 32% |
|---------|------|-----|-----|-----|-----|
| 1인 | 2,392,013 | 1,196,007 | 1,148,166 | 956,805 | 765,444 |
| 2인 | 3,932,658 | 1,966,329 | 1,887,676 | 1,573,063 | 1,258,451 |
| 3인 | 5,025,353 | 2,512,677 | 2,412,170 | 2,010,141 | 1,608,113 |
| 4인 | 6,097,773 | 3,048,887 | 2,926,931 | 2,439,109 | 1,951,287 |

### 신청 채널
| 채널 | 방법 | 특징 |
|------|------|------|
| **복지로** (bokjiro.go.kr) | 온라인 | 중앙부처 지원 대부분 |
| **정부24** (gov.kr) | 온라인 | 출산·육아 통합 신청 |
| **주민센터** | 방문 | 통합 신청 + 복잡한 서류 |
| **129** | 전화 | 보건복지부 상담 |
| **120** | 전화 | 지자체 민원 상담 |

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 적용.

### 면책 문구 (모든 응답 필수)
> ⚠️ 본 내용은 정보 제공 목적이며, 실제 수급 여부는 해당 기관에서 결정합니다.
> 최신 정책 및 신청: 복지로(www.bokjiro.go.kr) / 주민센터 / ☎129
