# Markdown 结构规范

每日文件路径：

- `~/weibo-digest/YYYY-MM-DD.md`

表头：

```markdown
# YYYY-MM-DD 微博关注摘要
| 发帖时间 | 发帖人 | 发帖内容 | 内容总结 | 原始链接 |
|---|---|---|---|---|
```

字段规则：

- `发帖时间`：本地时区解析后的发帖时间，格式 `YYYY-MM-DD HH:mm`。
- `发帖人`：显示名。
- `发帖内容`：原帖正文单行文本（禁止改写、禁止摘要化）。
- `内容总结`：<= 30 字，客观概括。
- `原始链接`：帖子 permalink。

字段分离规则：

- 除非原帖本身极短，否则 `发帖内容` 与 `内容总结` 不能相同。
- 若 `发帖内容` 明显过短且帖子存在更长正文，需回到原帖详情重新提取正文。

文本清洗：

- 换行替换为空格。
- `|` 转义为 `\|`。
- 合并多余空白。

去重与升级：

- 全文件按 `原始链接` 去重。
- 若历史文件表头为 `记录时间`，自动升级为 `发帖时间` 并保留历史行。
