---
name: weekly-synthesis
description: Create a comprehensive synthesis of the week's work and thinking
version: 1.0.0
author: theflohart
tags: [productivity, review, synthesis, patterns]
---

# Weekly Synthesis

Create a comprehensive synthesis of the week's work and thinking.

## Usage

```
/weekly-synthesis
```

## Analysis Process

1. **Gather Week's Work**
   - All notes created this week
   - All notes modified this week
   - Projects that saw activity

2. **Identify Patterns**
   - Recurring themes
   - Common challenges
   - Breakthrough moments
   - Energy patterns (what energized vs drained)

3. **Synthesize Learning**
   - Key insights that emerged
   - How thinking evolved
   - Connections discovered
   - Questions answered and raised

4. **Assess Progress**
   - Projects advanced
   - Areas maintained
   - Resources added
   - Items archived

## Output Format

Create a weekly synthesis note:

```markdown
# Weekly Synthesis - Week of [Date]

## Week at a Glance

- Notes created: [X]
- Projects active: [List]
- Major accomplishments: [List]

## Key Themes

### Theme 1: [Name]

- Where it appeared: [contexts]
- Why it matters: [significance]
- Next actions: [what to do]

### Theme 2: [Name]

- Where it appeared: [contexts]
- Why it matters: [significance]
- Next actions: [what to do]

## Major Insights

1. [Insight with context]
2. [Insight with context]

## Progress by Project

### [Project Name]

- What advanced:
- What's blocked:
- Next week's focus:

## Questions Emerged

- [Question 1 - and why it matters]
- [Question 2 - and why it matters]

## Energy Audit

- What gave energy:
- What drained energy:
- What to adjust:

## Connections Made

- [Note A] <-> [Note B]: [Why significant]
- [Concept X] <-> [Concept Y]: [New understanding]

## Next Week's Intentions

1. [Primary focus]
2. [Secondary focus]
3. [Thing to explore]

## To Process

- Inbox items: [count]
- Orphaned notes: [list]
- Missing connections: [identified]
```

## Follow-up Actions

- Archive completed projects
- Clean up inbox
- Update project status
- Plan next week's focus
