# Weekly Planner schema

This skill uses a small set of plain-text files (TOML + Markdown) stored in a `planner/` folder.

## Directory layout

A typical workspace layout:

```
planner/
  config.toml
  inbox.toml
  runbook.toml
  modes/
    MODE_DeepWork.md
    MODE_Ops.md
    MODE_Reset.md
    MODE_Relationships.md
    MODE_Shutdown.md
  weeks/
    WEEK_TEMPLATE.toml
    2026-W10.toml
    INDEX.md            # optional, auto-generated by sync scripts
  logs/                 # optional freeform notes
  scripts/
    new_week.py         # create a new week file from runbook
    rollover_week.py    # create next week + carry over unfinished bits
    validate.py         # deterministic validation
    sync_week.py        # Google Calendar sync via gog (optional)
    export_ics.py       # calendar export without Google tooling
```

## `config.toml`

`planner/config.toml` contains stable defaults.

Recommended fields:

- `timezone` (string): IANA timezone name used for calendar sync.
  - Example: `Europe/Berlin`, `Europe/London`, `America/New_York`

- `[day_bounds]` (table): optional planning hints.
  - `start` (HH:MM)
  - `end` (HH:MM)

- `[modes.<mode_key>]` (tables): user-defined mode keys.
  - `label` (string): human label shown in calendar titles when no explicit block title exists.
  - `default_block_minutes` (int): planning hint.
  - Optional: `min_block_minutes` (int)

- `[[weekly_nonnegotiables]]` (array of tables): planning hints.
  - `name` (string)
  - `count` (int)
  - `duration_minutes` (int)
  - Optional: `preferred_windows` (array of `["HH:MM","HH:MM"]`)
  - Optional: `preferred_days` (array of day strings: `Mon`..`Sun`)

- `[calendar]` (table): only needed for Google Calendar sync.
  - `planner_calendar_name` (string, optional): for humans only.
  - `planner_calendar_id` (string, required for sync): the Google Calendar ID.
  - `write_enabled` (bool): extra safety latch; must be `true` before `--apply` works.

- `[sync]` (table): optional sync behaviour.
  - `marker_prefix` (string, default `planner`): prefix used for private props and description markers.

## `inbox.toml`

`planner/inbox.toml` is **append-only**. It contains `[[items]]` entries.

Each `[[items]]` supports:

- `created` (string): RFC3339 timestamp (include offset).
- `text` (string): task description.
- `mode` (string): a key that exists under `[modes.*]`.
- `est_minutes` (int): estimate.
- `priority` (string): `low` | `medium` | `high`.
- `status` (string): `todo` | `doing` | `done` | `dropped`.
- `notes` (string): optional.

## `runbook.toml`

`planner/runbook.toml` defines recurring weekly blocks copied into each new week file.

It contains `[[blocks]]` entries with:

- `id` (string, required): stable identifier (must be unique across blocks).
- `mode` (string, required): mode key.
- `title` (string, required): displayed title.
- `day` (string, required): `Mon`..`Sun`.
- `start` (string, required): `HH:MM`.
- `minutes` (int, required): duration.
- `notes` (string, optional).

## Week file: `weeks/YYYY-Www.toml`

Week files are the main planning artefact.

### Top-level

- `week_start` (string): Monday date in ISO format: `YYYY-MM-DD`.

### `[goals]`

Keep goals short.

Recommended fields:

- `primary_outcome` (string)
- `maintenance_outcome` (string)
- `focus_tasks` (array of strings): 2–5 items.

### `[[time_blocks]]` (scheduled)

Time blocks are what gets synced to calendar.

Fields:

- `id` (string, required): unique within the week.
- `day` (string, required): `Mon`..`Sun`.
- `mode` (string, required): mode key.
- `start` (string, required): `HH:MM`.
- `minutes` (int, required)
- `title` (string, optional)
- `notes` (string, optional)

### `[[weekly_bits]]` (unscheduled, any day)

Fields:

- `id` (string, required)
- `text` (string)
- `est_minutes` (int)
- `mode` (string)
- `status` (string): `todo` | `done` | `skip`
- `notes` (string)

### `[[daily_bits]]` (unscheduled, on a specific day)

Fields:

- `day` (string, required): `Mon`..`Sun`.
- `id` (string, required)
- `text` (string)
- `est_minutes` (int)
- `mode` (string)
- `status` (string): `todo` | `done` | `skip`
- `notes` (string)

### `[review]`

Fields:

- `score` (int): 0–10.
- `wins` (array of strings)
- `fails` (array of strings)
- `what_i_learned` (string)
- `next_week_focus` (string)
