---
name: wed
description: "What Would Elon Do? - Transform any idea into a ruthless execution plan. One command to generate a full business strategy, MVP spec, go-to-market plan, and first-week action items. Think bigger. Move faster. /wed 'your idea'"
---

# What Would Elon Do? (WED)

> "When something is important enough, you do it even if the odds are not in your favor." - Elon Musk

Transform any idea into an actionable empire-building plan. This skill channels Elon's first-principles thinking, 100-hour work week energy, and "fuck it, ship it" mentality.

Stop overthinking. Start executing.

## Usage

```
/wed "your startup idea or problem"
```

## What You Get

### 1. First Principles Breakdown
Strip away every assumption. Find the atomic truth of your problem. What would physics say? What's actually impossible vs just hard?

### 2. 10x Moonshot Reframe
Why are you thinking so small? If this were a SpaceX mission, what would you be building? Think 10x, not 10%.

### 3. MVP in a Weekend
Brutally scoped. No feature creep. What's the absolute minimum you can ship in 48 hours that proves the concept? Tech stack, features, done.

### 4. The Musk Memo
An internal announcement written exactly like Elon would write it. Direct. Aggressive. No bullshit. Ends with a forcing function deadline.

### 5. Week 1 War Plan
Day-by-day breakdown. Hour counts. Specific deliverables. No fluff, just execution.

## Examples

```
/wed "I want to build a better calendar app"
/wed "How do I compete with Uber in my city"
/wed "I have $500 and want to start a SaaS"
/wed "I want to automate my entire job"
/wed "Build me a $10k/month business"
```

## Why This Works

Most people fail because they:
- Overthink instead of ship
- Build features nobody wants
- Take 6 months for what should take 6 days
- Listen to people who've never built anything

This skill forces you into Elon mode:
- Compress timelines ruthlessly
- Cut scope to the bone
- Ship ugly, iterate fast
- Ignore the haters, trust the process

## The Philosophy

**"If you need inspiring words, don't do it."** - Elon Musk

This isn't about motivation. It's about execution. You give WED an idea, it gives you a war plan. What you do with it is up to you.

The best founders ship fast and fix later. They don't wait for permission. They don't need a perfect plan. They need a good-enough plan and the balls to execute.

That's what this skill gives you.

---

## Technical Details

For the full execution workflow and advanced configuration, see `rules/logic.md`.

---

**Created by:** [@theonejvo](https://x.com/theonejvo)

### Changelog

**v1.0.0** - Initial release
- First-principles analysis engine
- Moonshot reframing
- Weekend MVP generator
- Musk memo writer
- Week 1 war planning
