---
name: wechat-mp-writer
description: 微信公众号文章全流程写作助手。支持热点选题、文章撰写、AI去味润色（去除机器感）、配图建议、一键发布到公众号草稿箱。适用于技术博主、自媒体创作者、企业公众号运营等场景。当用户需要写公众号文章、润色内容、寻找配图或发布到微信时使用此skill。
---

# 微信公众号写作助手

全流程辅助微信公众号文章创作，从选题到发布一站式解决。

## 核心功能

### 1. 热点选题建议
- 根据领域/关键词搜索最新热点
- 提供选题角度和切入点建议
- 生成文章大纲框架

### 2. 文章撰写
- 支持多种风格：技术干货、故事叙事、观点评论、教程指南
- 自动适配公众号格式（标题、段落、重点标注）
- 生成引人入胜的开头和有行动号召的结尾

### 3. AI 去味润色
**核心功能**：去除 AI 写作痕迹，让文章读起来像真人写的

润色策略：
- 加入个人口语化表达（"说实话..."、"其实..."、"讲真..."）
- 使用不完美但真实的句式（适当重复、口语停顿）
- 插入具体场景和细节（时间、地点、真实案例）
- 加入情感波动（惊喜、困惑、恍然大悟）
- 使用接地气的比喻（避免过于书面的修辞）
- 适当使用网络流行语（但不过度）
- 长短句交错，避免过于规整的排比

### 4. 配图建议
- 根据文章内容推荐配图类型
- 搜索合适的配图素材
- 提供封面图设计建议

### 5. 发布到公众号
- 生成符合微信格式的 Markdown
- 调用 wechat-mp-publisher 发布到草稿箱
- 支持设置标题、作者、摘要

## 使用流程

```
用户输入需求
    ↓
选择功能模式：
  - 从零开始写 → 选题 → 大纲 → 撰写 → 润色 → 配图 → 发布
  - 已有草稿 → 润色 → 配图 → 发布
  - 仅润色 → 去味处理
  - 仅发布 → 调用发布工具
    ↓
生成最终文章
    ↓
（可选）发布到公众号草稿箱
```

## 写作风格指南

### 技术干货风格
- 开门见山，先给结论
- 步骤清晰，代码/命令可复制
- 加入踩坑记录和解决方案
- 结尾总结核心要点

### 故事叙事风格
- 场景化开头（时间、地点、人物）
- 情节推进有起伏
- 金句点睛
- 引发共鸣的结尾

### 观点评论风格
- 明确立场，不模棱两可
- 论据充分，数据支撑
- 承认反方观点并回应
- 给出行动建议

## AI 去味检查清单

润色后检查文章是否还有 AI 痕迹：

- [ ] 没有"首先/其次/最后/综上所述"等模板化连接词
- [ ] 没有过于完美的三段式结构
- [ ] 有具体的个人经历或观察
- [ ] 有情感词（惊喜、崩溃、感动、无语）
- [ ] 有口语化表达（"说白了..."、"你可能想不到..."）
- [ ] 长短句交错，不是每段都一样长
- [ ] 有适当的括号补充（（笑）、（别问我怎么知道的））

## 配图建议规则

| 文章类型 | 配图建议 |
|---------|---------|
| 技术教程 | 代码截图、架构图、流程图、效果演示 |
| 产品测评 | 产品实拍、对比图、细节特写 |
| 行业观点 | 数据图表、趋势图、相关新闻截图 |
| 个人故事 | 场景照片、聊天截图、相关物品 |
| 工具推荐 | 软件界面、功能截图、前后对比 |

## 发布格式

生成的 Markdown 需符合 wechat-mp-publisher 要求：
- 使用标准 Markdown 语法
- 图片使用 `![描述](URL)` 格式
- 代码块指定语言类型
- 标题层级使用 ## 和 ###

## 工具调用

发布时使用 `wechat-mp-publisher` skill（如已安装）：
```
将生成的 Markdown 内容传递给 wechat-mp-publisher 进行发布
```

如果用户未安装发布工具，提供手动发布指南。
