# 微信公众号发布常见问题 (Remote MCP 版)

## 1. 核心误区：IP 白名单配置

使用本远程技能时，**必须将 MCP 服务所在公网 IP** 加入白名单，而**不是**你当前操作机器的 IP。

**为什么？**
- 所有的 API 请求（包括获取 Access Token、上传图文、上传素材）都是由 **远程 MCP 服务器** 发起的。
- 你本地的 OpenClaw 只负责发指令给 MCP，不直接与微信交互。
- 即使你在家里用动态 IP 也没关系，只要 MCP 服务器 IP 固定即可。

## 2. 封面图 (Cover) 加载失败

**错误信息**: `cover not found` 或 `upload image failed`

**常见原因**:
1. **相对路径失效**: 远程 MCP 无法访问你本地磁盘上的相对路径 `./assets/cover.jpg`。
2. **图床防盗链**: 使用了某些开启防盗链的图床链接。

**解决方案**:
- **推荐**: 使用公网可访问的 URL（如 GitHub Pages, S3, OSS 等）。
- **高级**: 如果必须用本地图片，需搭建文件服务让 MCP 可访问，或者直接将图片转为 Base64 嵌入（不推荐，体积过大）。

## 3. 文章排版错乱

**现象**: 发布成功，但在手机预览时样式丢失或错位。

**原因**:
- 微信编辑器对某些 CSS 属性支持不佳。
- 远程 MCP 上的 `wenyan-cli` 版本过旧。

**检查**:
- 确认远程服务器安装了最新版 `wenyan-cli`。
- 尝试更换主题 (`lapis`, `phycat` 等标准主题兼容性最好)。
