---
name: wechat-mp-cn
description: 微信公众号监控 - 文章监控、阅读量追踪、舆情分析（WeChat Official Account）
metadata:
  openclaw:
    emoji: "📱"
    category: "social"
    tags: ["wechat", "mp", "china", "official-account", "monitoring"]
---

# 微信公众号监控

文章监控、阅读量追踪、舆情分析。

## 功能

- 📱 文章监控
- 📊 阅读量追踪
- 🔍 舆情分析
- 📢 订阅号/服务号管理

## ⚠️ 限制

微信公众号 API 需要认证，需要以下之一：

### 1. 官方 API（需认证）

```bash
# 需要微信开放平台认证
# https://open.weixin.qq.com/
```

### 2. 第三方工具

- [WeChatpy](https://github.com/wechatpy/wechatpy) - Python SDK
- [EasyWechat](https://github.com/overtrue/wechat) - PHP SDK
- [NewRank](https://www.newrank.cn/) - 数据分析平台

### 3. 手动监控

- 搜狗微信搜索: https://weixin.sogou.com/
- 西瓜数据: https://data.xiguaji.com/

## 使用场景

### 1. 竞品监控

- 追踪竞品发布
- 分析内容策略
- 学习爆款文章

### 2. 舆情监控

- 品牌关键词
- 行业热点
- 危机预警

### 3. 内容分析

- 阅读量趋势
- 点赞/评论分析
- 分享传播

## 数据字段

| 字段 | 说明 |
|------|------|
| title | 文章标题 |
| author | 作者 |
| publish_time | 发布时间 |
| read_count | 阅读量 |
| like_count | 点赞数 |
| comment_count | 评论数 |

## 与其他平台对比

| 平台 | 类型 | 特点 |
|------|------|------|
| **公众号** | 长图文 | 私域流量 |
| 小红书 | 图文+短视频 | 公域流量 |
| 抖音 | 短视频 | 算法推荐 |
| 知乎 | 问答 | 知识分享 |

## 注意事项

1. **API 限制**: 需要认证
2. **频率控制**: 避免被封
3. **数据合规**: 仅用于个人研究

---

*版本: 1.0.0*
