# 写作风格指南（释永信风格）

## 核心原则

**不说教，不引导，不规整。**

---

## 禁用词清单（重要）

❌ **绝对禁止：**
- 首先/其次/最后/综上
- 本文/本篇/笔者/作者
- 由此可见/总而言之/总的来说
- 挺有意思/有个细节/有个对比
- 说点实际的/说回 XX
- 告诉我们/让我们/带大家
- 表演式反应（惊呆了/震撼到/愣了一下）
- AI 式自我声明（写这事儿不是想骂谁/不是想安慰谁）
- 所以啊/但话说回来/当然

✅ **替换方式：**
- "挺有意思" → 直接删掉
- "说点实际的" → 直接说事
- "所以啊" → 直接删掉
- "写这事儿不是想 XX" → 直接写

---

## 结构要求

❌ 禁止：
- 小标题编号（01、02、03...）
- 列表（1.2.3.或 bullet points）
- "首先/其次/最后"这类连接词
- "你怎么看？评论区聊聊"这种引导互动
- 结尾总结升华

✅ 要求：
- 自然段落流动，不用小标题
- 用分隔线（---）划分大章节即可
- 2-4 句一段，长短混用
- 结尾留白，不说破

---

## 开头写法

**金句 + 反转**

示例：
> 佛曰：色即是空。
> 但对释永信来说，空即是房产开发、控股公司、四星级酒店和流量火热的微博账号。

> 代码能跑，人就可以退下了。
> 这两天 GitHub 上那个叫 deer-flow 的开源项目，还真有点这个意思。

---

## 语言特点

**犀利，有态度，善用对比反讽**

示例：
> 佛门讲"空"，但释永信转而谈"账面盈余"；佛门讲"戒"，他频频召开"股东大会"；佛门讲"苦修"，他关注的是"品牌升级"。

> 这就像把"裁员"改成"毕业"，把"降薪"改成"结构性优化"，把"倒闭"改成"战略调整"。名字好听了，事儿还是那个事儿。

> 自由这东西，一旦尝过，就回不去了。

---

## 数据使用

**具体数字 + 来源，不模糊**

❌ 错误：
- "很多企业"
- "大量资金"
- "近年来"

✅ 正确：
- "关联企业多达 18 家"
- "4.52 亿拿下郑州地块"
- "注册了 700 多个少林寺相关商标"
- "售价 9999 元的秘籍"
- "87 万粉微博账号"

---

## 时间线

**有历史纵深，不只看当下**

示例：
> 1981 年，16 岁的安徽阜阳人刘应成在嵩山投身空门...
> 1987 年开始，他最初的"创业项目"就很佛门化...
> 2008 年，释永信创立"河南少林无形资产管理有限公司"...
> 2015 年 7 月，有关少林寺方丈释永信的网络公开举报成为舆论焦点...
> 终于，到了这个周末...

---

## 比喻

**精准，有画面感**

示例：
> 可以说他是佛门的贾跃亭，是寺庙界的马云。

> 浓浓的香火味伴随着欧元的芬芳。

> 一手木鱼一手算盘的跨界天才。

---

## 结尾

**留白 + 金句，不引导互动**

❌ 错误：
> 你觉得 AI 会取代程序员吗？欢迎在评论区聊聊你的看法👇
> 如果觉得这篇文章对你有帮助，记得点赞 + 在看，也欢迎转发给更多朋友～

✅ 正确：
> 至于最终结果？没有人知道。或许释永信会再次微笑归来，或许他会彻底隐退甚至真的"落马"。

> 释永信是一个时代的缩影：或许这个时代本身拜的从来就不是佛，只是佛像身后那些漂亮的商业计划书。

> 但至少，不怕了。

---

## 字数

1500-2500 字（含标点）

---

## 自检清单

生成后检查：
- [ ] 有没有小标题编号？有→删掉
- [ ] 有没有列表？有→改成自然叙述
- [ ] 有没有"你怎么看"这种引导？有→删掉
- [ ] 数据够不够具体？不够→补充
- [ ] 有时间线纵深吗？没有→加历史背景
- [ ] 结尾是不是留白？不是→重写

---

## 使用方式

每次生成文章时，把这份指南附在 prompt 里，加上：

> 严格按照以上风格写作。写完后自检，不符合的改。
