---
name: wechat-auto-publisher-skill
description: 公众号自动化技能包 - 从选题到写作到发布全流程自动化，热点监控+AI写作+草稿管理。适合自媒体运营者、内容创作者。
version: 1.0.0
author: AI-Company
tags: [wechat, mp, article, automation, ai-writing, 公众号, 自动化]
license: MIT
---

# 公众号自动化技能包

## 描述

微信公众号全自动发布系统，从选题到写作到发布全流程自动化。

**触发条件：**
- 用户提到"公众号"、"微信文章"、"热点监控"、"AI写作"、"自动发布"
- 用户想要自动生成公众号文章
- 用户想要监控科技热点

## 核心功能

1. **热点监控** - 抓取微博/知乎/GitHub/HackerNews 等平台热点
2. **智能筛选** - 根据关键词过滤出 AI/科技相关话题
3. **文章生成** - AI 自动写作，符合公众号风格
4. **草稿管理** - 生成 Markdown 草稿，方便人工审核

## 使用方法

### 基础命令

```bash
# 完整流程：监控热点 + 生成文章
/wx-publish

# 仅监控热点
/wx-monitor

# 仅生成文章（使用已有选题）
/wx-generate [数量]

# 查看 GitHub Trending
/wx-github

# 查看 Hacker News
/wx-hn
```

### 参数说明

| 参数 | 说明 | 默认值 |
|------|------|--------|
| 数量 | 生成文章数量 | 1 |
| 赛道 | 内容赛道（AI/科技/创业） | AI |

## 配置要求

### 环境变量

在 `.env` 文件中配置：

```env
# 百炼 API（通义千问）- 用于文章生成
DASHSCOPE_API_KEY=your_api_key

# 公众号配置（发布功能需要）
WECHAT_APP_ID=your_app_id
WECHAT_APP_SECRET=your_app_secret
```

### 修改配置

编辑 `config.js` 修改：
- 监控关键词
- 文章风格
- 发布时间
- 每日篇数

## 工作流程

```
┌─────────────┐    ┌─────────────┐    ┌─────────────┐
│  热点监控   │ →  │  选题筛选   │ →  │  文章生成   │
│  (多平台)   │    │  (关键词)   │    │  (AI写作)   │
└─────────────┘    └─────────────┘    └─────────────┘
                                              ↓
                                      ┌─────────────┐
                                      │  草稿保存   │
                                      │  (人工审核) │
                                      └─────────────┘
```

## 数据源

| 平台 | 状态 | 类型 |
|------|------|------|
| GitHub Trending | ✅ 稳定 | 科技开源 |
| Hacker News | ✅ 稳定 | 科技资讯 |
| 知乎热榜 | ✅ 可用 | 综合热点 |
| 微博热搜 | ⚠️ 需处理 | 社会热点 |
| 36 氪 | ✅ 可用 | 商业科技 |
| 虎嗅 | ⚠️ 需处理 | 商业科技 |

## 输出示例

### 热点监控结果
```
=== 推荐选题 TOP 5 ===
1. [github] microsoft/semantic-kernel (热度：95)
2. [hackernews] OpenAI releases new model (热度：92)
3. [zhihu] 如何看待 AI 的发展？(热度：88)
4. [weibo] GPT-5 发布预告 (热度：85)
5. [36kr] AI 创业融资动态 (热度：80)
```

### 生成的文章草稿
```markdown
---
title: AI 这波操作，有点东西
topic: OpenAI 发布新模型
source: hackernews
status: draft
---

# AI 这波操作，有点东西

最近科技圈又炸了...
```

## 注意事项

1. **API 限制** - 百炼 API 有调用频率限制
2. **内容审核** - 建议人工审核后再发布
3. **账号安全** - 避免短时间内大量发布
4. **版权问题** - 注意引用内容的版权

## 扩展功能

### 自定义写作风格

编辑 `style-guide.md` 修改写作风格：
- 犀利吐槽风
- 专业科普风
- 轻松幽默风

### 定时任务

使用系统任务计划程序设置定时执行：
- Windows: 任务计划程序
- Linux: cron

## 依赖

- node-fetch - HTTP 请求
- cheerio - HTML 解析
- dotenv - 环境变量
- node-cron - 定时任务（可选）

## 版本历史

- V1.0 - 初始版本
  - 热点监控（6 个平台）
  - AI 文章生成
  - 草稿管理

## 适用人群
- 自媒体运营者
- 内容创作者
- 公众号小编
- 知识付费博主
- 营销团队

## 价格
- 基础版：¥199（热点监控 + 文章生成）
- 进阶版：¥299（+ 自动发布 + 定时任务）
- 专业版：¥499（+ 多账号 + 数据分析）

---

*开发者：AI-Company*
*联系：通过ClawHub*