# Reviewer Rubric — WeChat 公众号 Article Quality

> v4 — 2026-02-20. Craft-only revision. Reviewers judge TEXT, not outcomes. All dimensions are observable in the article itself — no prediction of reader behavior, shares, or platform metrics. WeChat signals (完读率, 分享, 收藏) are outcomes determined by distribution, timing, and audience size. A reviewer reading a draft cannot predict them. What a reviewer CAN judge: whether the writing is clear, original, compelling, and well-evidenced.

## Scoring Dimensions

### Insight Density (洞察密度) — Weight: 20%

How many genuinely surprising, non-obvious ideas per 1000 characters? This is the core value proposition of any article.

| Score | Criteria |
|-------|----------|
| 9-10 | Multiple "我靠，没想到" moments. Each major section delivers a non-obvious insight backed by evidence. The ideas are SPECIFIC and nameable, not vague gestures at complexity. Reader learns something they couldn't have guessed. |
| 7-8 | 1-2 strong insights, rest is competent but predictable. |
| 5-6 | Rehashes known ideas clearly. Well-organized but no surprises. |
| 3-4 | Obvious points stated with confidence. Reader already knows all of this. |
| 0-2 | Zero insight. Pure filler or platitude. |

**Key test:** For each section, can you state the non-obvious claim in one sentence? If the sentence is something anyone would say, score ≤6.

### Originality (新鲜感) — Weight: 15%

Unique angle is the #6 trait of viral articles (南方传媒书院). In an era of AI-generated content, originality is the only moat.

| Score | Criteria |
|-------|----------|
| 9-10 | Genuinely new insight or framing. Reader thinks "I never thought about it that way." Has a specific, nameable core idea that cannot be found in 1000 other articles on the same topic. The insight is EARNED through research/experience, not manufactured. |
| 7-8 | Fresh angle on a known topic. Not groundbreaking, but not the same take everyone else has. |
| 5-6 | Competent synthesis of existing ideas. Well-written but the reader has seen this before. |
| 3-4 | Rehashed talking points. Could be generated by anyone with access to the same sources. |
| 0-2 | Plagiarism-adjacent. Zero original thought. |

### Emotional Resonance (情感共鸣) — Weight: 15%

共鸣 is the #1 trait of viral articles. The reader must feel "说的就是我" or experience genuine emotional arousal (positive or negative). Low-arousal emotions (contentment, sadness) don't drive shares; high-arousal emotions (awe, anger, anxiety, inspiration) do.

| Score | Criteria |
|-------|----------|
| 9-10 | Hits reader in the gut. They feel genuinely different after reading — moved, fired up, unsettled, or deeply seen. Emotion is EARNED by evidence and storytelling, not manufactured by rhetoric. Complete emotional arc: setup → tension → resolution/revelation. |
| 7-8 | Good emotional moments but some flat stretches. The feeling is real but not sustained. |
| 5-6 | Occasional emotional flickers. Mostly intellectual, not visceral. |
| 3-4 | Flat. Reader feels nothing. Pure information delivery. |
| 0-2 | Actively annoying — condescending, preachy, or manipulatively sentimental. |

### Completion Power (完读力) — Weight: 15%

WeChat platform avg completion rate: 15-25%. Top articles: 45-60%. This dimension predicts whether readers finish or bail. It subsumes old "hook" and "engagement" — because what matters is not just the opening OR the middle, but whether every section earns the next scroll.

| Score | Criteria |
|-------|----------|
| 9-10 | Unputdownable. Every paragraph creates a micro-reason to keep reading: unanswered question, escalating stakes, surprising turn, building pattern. The "3-second test" passes on EVERY screen-scroll, not just the opening. No section where the reader's thumb hovers over the back button. Mobile-optimized: short paragraphs (≤4 lines on phone), visual breathing, varied rhythm. |
| 7-8 | Strong pull with 1-2 flat spots. Reader skims a section but comes back. |
| 5-6 | Starts strong, sags in the middle. Reader finishes out of obligation, not desire. |
| 3-4 | Only the opening is compelling. Most readers bail before halfway. |
| 0-2 | Even the opening fails. Wall of text, no hooks, no reason to continue. |

**Mobile check:** Is there ever a full phone screen (5+ lines) without a visual break, subheading, bold text, or new paragraph? Each occurrence = -1.

### Voice (语感) — Weight: 10%

Natural Chinese that sounds like a specific person thinking out loud, not a committee or algorithm.

| Score | Criteria |
|-------|----------|
| 9-10 | Unmistakably human. Has a personality — you could recognize the author blind. Sentence rhythm varies naturally. Colloquial without being sloppy. Would pass the "read aloud" test — sounds like someone talking, not reciting. |
| 7-8 | Mostly natural with minor stiff patches. |
| 5-6 | Functional but generic. Could be any competent writer. |
| 3-4 | Stiff, formal, or inconsistent. Switches registers awkwardly. |
| 0-2 | Obvious 翻译腔, 教材腔, or 鸡汤腔. |

### Evidence (论据) — Weight: 10%

Verifiable real cases are the #6 trait. Data and specifics build credibility and give readers ammunition for re-sharing ("据xxx研究...").

**HARD RULE — Source Attribution:** Every claim citing a study, experiment, or survey MUST include enough information for readers to verify: researcher/team name, institution, and publication venue or year. "某大学的研究发现" is NOT acceptable — must be "MIT的Ethan Mollick团队发表在《Nature》上的研究发现". The article MUST end with a numbered reference list (参考文献) linking claims to sources. Failure to provide verifiable attribution for key claims = automatic cap at 7.

| Score | Criteria |
|-------|----------|
| 9-10 | Every major claim backed by specific, verifiable evidence: named researchers, institutions, publication venues, concrete numbers. Sources are authoritative and recent. Evidence SURPRISES — it's not the obvious example everyone uses. Article ends with a complete reference list. |
| 7-8 | Good evidence for most claims. 1-2 assertions lack full attribution. Reference list present but incomplete. |
| 5-6 | Some evidence but also hand-waving. "有研究表明" without saying which research. No reference list. |
| 3-4 | Mostly opinion dressed as fact. |
| 0-2 | Pure assertion. No evidence at all. |

### Content Timeliness (内容时效性) — Weight: 10%

Is the article's core argument anchored to universal ideas, or does it depend on this week's news? This is observable in the text — look at what the claims rest on.

| Score | Criteria |
|-------|----------|
| 9-10 | Core argument rests on principles, frameworks, or human nature — not specific tools, versions, or events. Examples are illustrative, not load-bearing (swap them out, argument still holds). Teaches a way of thinking, not just current facts. |
| 7-8 | Mostly enduring. Some references may date but the main argument holds. |
| 5-6 | Mixed. Core idea has value but heavily tied to current context. |
| 3-4 | Mostly ephemeral. Depends on specific products/events that will be irrelevant in a year. |
| 0-2 | Pure news recap. Zero value once the moment passes. |

### Title (标题) — Weight: 5%

Title determines open rate (打开率). Platform avg: 1.9%, good: 4.3%+. But we weight it only 5% because a great title on a bad article is worse than useless — it's a trust violation that loses followers.

| Score | Criteria |
|-------|----------|
| 9-10 | Irresistible curiosity gap. Reader MUST click. ≤26 characters. Specific and concrete, not vague. Promises something the article delivers. Would stop a thumb mid-scroll in a notification list. |
| 7-8 | Good click appeal, slightly generic. |
| 5-6 | Descriptive but not compelling. |
| 3-4 | Weak, too long, or misleading. |
| 0-2 | Terrible or clickbait that article doesn't deliver. |

---

## Weight Summary

| Dimension | Weight | What Reviewer Observes |
|-----------|--------|----------------------|
| Insight Density (洞察密度) | 20% | Non-obvious ideas per section |
| Originality (新鲜感) | 15% | Unique framing vs rehashed takes |
| Emotional Resonance (情感共鸣) | 15% | Earned emotional arc in the text |
| Completion Power (完读力) | 15% | Pacing, hooks, micro-tension per scroll |
| Voice (语感) | 10% | Natural Chinese, personality, rhythm |
| Evidence (论据) | 10% | Specific, named, verifiable sources |
| Content Timeliness (内容时效性) | 10% | Universal vs news-dependent argument |
| Title (标题) | 5% | Clarity, specificity, length |
| **Total** | **100%** | |

## Pass/Fail Criteria

- **Pass:** `weighted_total >= 9.0` AND no single dimension below 7 AND Originality >= 8
- **Fail:** `weighted_total < 9.0` OR any single dimension below 7 OR Originality < 8

**Why Originality >= 8 is mandatory:** A perfectly executed generic article is still a generic article. It won't go viral, won't be remembered, won't build the account's reputation. Originality is the non-negotiable.

### Hard Blockers (automatic FAIL regardless of score)

1. **教材腔 (textbook voice):** Academic phrasing, stiff connectors, impersonal tone.
2. **翻译腔 (translation smell):** Chinese mirroring English syntax.
3. **鸡汤腔 (chicken soup):** Empty motivational platitudes. Poster-ready sentences with zero substance.
4. **灌水 (filler/padding):** Paragraphs that add no new information, insight, or emotion. Deletion test: if you remove it and nobody notices, it's 灌水.
5. **模板化 (template writing):** 问题→理论→案例→建议→鸡汤结尾 without structural surprise.
6. **标题党 (clickbait):** Title promises what article doesn't deliver. This is the fastest way to lose followers.

## Anti-Patterns

- **"翻译腔":** English-mirrored syntax
- **"鸡汤化":** Empty motivational platitudes
- **"教材体":** Academic tone
- **"标题党":** Title promises what article doesn't deliver
- **"流水账":** Listing without insight
- **"万金油文":** Article so generic it could be about any topic with minor word swaps
- **"套路结构":** Predictable template with no structural innovation

## Feedback Format

For each dimension scoring below 8, provide:

```json
{
  "dimension": "shareability",
  "score": 5,
  "issue": "No clear share trigger — reader has no reason to forward this",
  "quote": "relevant passage",
  "suggestion": "specific rewrite direction"
}
```

## Data Sources

- NewRank 2024 Annual Report: 30.78万篇 10W+ articles (7 per 10,000)
- 36kr/NewRank 2026 Study (7,242 accounts): 1.9% open rate, 4.3% headline, 50% completion of openers, 16.1% reads from shares
- 南方传媒书院/澎湃 10W+ Analysis: 10 traits of viral articles
- WeChat platform metrics: 完读率 avg 15-25%, emotional content 45-60%
- Zhang Xiaolong quote: 70-80% of early OA reads from Moments shares (二八定律)
- WeChat recommendation algorithm signals: 完读率, 分享, 点赞/在看, 收藏, 留言
