---
name: Website
description: Build fast, accessible, and SEO-friendly websites with modern best practices.
metadata: {"clawdbot":{"emoji":"🌐","os":["linux","darwin","win32"]}}
---

# Website Development Rules

## Performance
- Images are the #1 cause of slow sites — use WebP/AVIF, lazy-load below-the-fold, and set explicit width/height to prevent layout shift
- Render-blocking CSS delays first paint — inline critical CSS in `<head>`, defer the rest
- Third-party scripts (analytics, chat widgets) often add 500ms+ — load them with `async` or `defer`, audit regularly
- Fonts cause invisible text flash (FOIT) — use `font-display: swap` and preload critical fonts
- Measure with Lighthouse in incognito mode — extensions skew results

## Mobile First
- Start CSS with mobile styles, add complexity with `min-width` media queries — easier to scale up than strip down
- Touch targets need 44x44px minimum — fingers are imprecise, small buttons frustrate users
- Test on real devices, not just browser DevTools — throttling simulation misses real-world jank
- Horizontal scroll is a critical bug — test every page at 320px width minimum
- `viewport` meta tag is required: `<meta name="viewport" content="width=device-width, initial-scale=1">`

## Accessibility
- Every `<img>` needs `alt` text — empty `alt=""` for decorative images, descriptive text for meaningful ones
- Color contrast ratio 4.5:1 minimum for body text — use WebAIM contrast checker
- Form inputs must have associated `<label>` elements — placeholders alone are not accessible
- Keyboard navigation must work — test every interactive element with Tab key
- Screen readers announce heading hierarchy — use H1-H6 in logical order, never skip levels

## HTML Structure
- One `<h1>` per page only — it's the page title, not a styling tool
- Use semantic elements: `<nav>`, `<main>`, `<article>`, `<aside>`, `<footer>` — they communicate structure to browsers and assistive tech
- `<button>` for actions, `<a>` for navigation — don't use divs with click handlers
- External links should have `rel="noopener"` — prevents security vulnerability with `target="_blank"`
- Validate HTML — broken markup causes unpredictable rendering across browsers

## CSS Patterns
- Avoid `!important` — it breaks cascade and makes debugging painful. Fix specificity instead
- Use relative units (`rem`, `em`, `%`) over fixed `px` for text — respects user font size preferences
- CSS custom properties (variables) reduce repetition — define colors and spacing once, use everywhere
- Flexbox for 1D layouts, Grid for 2D — don't force one to do the other's job
- Test without CSS loading — content should still be readable in plain HTML

## Common Mistakes
- Missing favicon causes 404 spam in server logs — always include one, even a simple PNG
- Not setting `<html lang="en">` breaks screen reader pronunciation
- Hardcoded `http://` links break on HTTPS sites — use protocol-relative `//` or always `https://`
- Assuming JavaScript is available — core content should work without JS (progressive enhancement)
- Forgetting print styles — add `@media print` for pages users might print (receipts, articles)

## Before Launch
- Test all forms actually submit — broken contact forms lose leads silently
- Check 404 page exists and is helpful — default server 404 looks unprofessional
- Verify social sharing previews with Open Graph tags — test in Facebook/Twitter debuggers
- Submit sitemap to Google Search Console — speeds up indexing
- Set up uptime monitoring — know when your site goes down before users tell you
