---
name: webclaw
version: 1.0.11
description: >
  Web dashboard for OpenClaw. Browser-based UI for any installed skill.
  Schema-driven rendering, JWT auth, RBAC, AI chat, real-time updates.
  Install web dashboard, manage users, configure SSL HTTPS, web admin panel.
author: AvanSaber / Nikhil Jathar
homepage: https://www.erpclaw.ai
source: https://github.com/avansaber/webclaw
tier: 0
category: infrastructure
requires: []
database: ~/.openclaw/webclaw/webclaw.sqlite
user-invocable: true
tags: [web, dashboard, ui, admin, login, ssl, https, users, roles]
metadata: {"openclaw":{"type":"executable","install":{"pre":"bash scripts/check_deps.sh","post":"bash scripts/install.sh","pip":"api/requirements.txt"},"requires":{"bins":["python3","node","npm","nginx","certbot","git","sudo"],"env":[],"optionalEnv":["WEBCLAW_DOMAIN"]},"os":["linux"]}}
cron:
  - expression: "0 2 * * *"
    timezone: "UTC"
    description: "Clean expired sessions and check SSL cert renewal"
    message: "Using webclaw, run the maintenance action."
    announce: false
---

# webclaw

You are the **Web Dashboard administrator** for this OpenClaw instance. You manage a browser-based UI that provides forms, tables, charts, and AI chat for every installed skill — with zero per-skill custom code.

## Security Model

- **HTTPS enforced** via Let's Encrypt (setup-ssl action)
- **JWT authentication** — access tokens (15 min) + refresh tokens (7 days, httpOnly cookies)
- **RBAC** — role-based permission checks before every skill action
- **Rate limiting** — 5/min auth, 30/min writes, 100/min general (nginx)
- **Audit logging** — all mutating actions logged to audit_log table
- Passwords hashed with PBKDF2-HMAC-SHA256 (600K iterations)
- Session invalidation on password change

### Privilege Requirements

Installation requires **sudo** access for the following system-level operations:
- **nginx**: writes reverse proxy config to `/etc/nginx/sites-enabled/webclaw`
- **systemd**: creates `webclaw-api.service` and `webclaw-web.service` in `/etc/systemd/system/`
- **certbot**: requests Let's Encrypt SSL certificates (setup-ssl action only)
- **git**: clones full source from `https://github.com/avansaber/webclaw` on first install

**Note:** The ClawHub package is a lightweight metadata package (SKILL.md + scripts). The full application (API server, Next.js frontend, templates) is cloned from GitHub at a pinned release tag during post-install. This requires git and internet access on the target server.

**Supply chain note:** The install script clones a specific tagged release (`v1.0.10`) from https://github.com/avansaber/webclaw — not HEAD. pip and npm dependencies are installed from standard registries within an isolated venv. Temporary passwords generated by `create-user` and `reset-password` actions are output to the bot so the admin can relay them to the user — these should be changed on first login.

No credentials or API keys are required. All data is stored locally in SQLite.

### Skill Activation Triggers

Activate this skill when the user mentions: web dashboard, web UI, web interface, login page, HTTPS, SSL certificate, web users, roles, RBAC, nginx, web admin, dashboard access, browser access, setup web, install web dashboard.

### Setup (First Use Only)

**IMPORTANT:** After installation, tell the user to open the setup page in their browser:

> Open **https://YOUR_SERVER/setup** to create your admin account.

Steps:
1. Open the URL shown in the install output (e.g., `https://1.2.3.4/setup`)
2. Create the first admin account (email + password)
3. Log in — all installed skills appear in the sidebar

To enable HTTPS with a custom domain: say "Set up SSL for yourdomain.com"

## Quick Start (Tier 1)

### Check Status
```
Using webclaw, show me the dashboard status
→ runs: status
```

### Enable HTTPS
```
Set up SSL for erp.example.com
→ runs: setup-ssl --domain erp.example.com
```

### Create a Web User
```
Create a web user for alice@company.com with Manager role
→ runs: create-user --email alice@company.com --full-name "Alice" --role Manager
```

### Reset a Password
```
Reset the web password for alice@company.com
→ runs: reset-password --email alice@company.com
```

## All Actions (Tier 2)

| Action | Args | Description |
|--------|------|-------------|
| `status` | — | Service status, SSL, user count |
| `setup-ssl` | `--domain` | Configure HTTPS with Let's Encrypt |
| `renew-ssl` | — | Check + renew SSL certificate |
| `list-users` | — | List all web dashboard users |
| `create-user` | `--email`, `--full-name`, `--role` | Create user with temp password |
| `reset-password` | `--email` | Generate new temp password |
| `disable-user` | `--email` | Disable a user account |
| `list-sessions` | — | Show active login sessions |
| `clear-sessions` | — | Force all users to re-login |
| `maintenance` | — | Cron: clean sessions, check cert |
| `restart-services` | — | Restart API + frontend services |
| `show-config` | — | Display current configuration |

### Quick Command Reference

| User says | Action |
|-----------|--------|
| "Is the dashboard running?" | `status` |
| "Set up SSL for example.com" | `setup-ssl --domain example.com` |
| "Who has web access?" | `list-users` |
| "Add web user bob@co.com" | `create-user --email bob@co.com` |
| "Reset password for bob" | `reset-password --email bob@co.com` |
| "Disable bob's web access" | `disable-user --email bob@co.com` |
| "Who's logged in?" | `list-sessions` |
| "Force everyone to re-login" | `clear-sessions` |
| "Restart the web dashboard" | `restart-services` |
| "Show web dashboard config" | `show-config` |

### Proactive Suggestions

After `create-user`: remind user to share the temp password securely.
After `setup-ssl`: confirm HTTPS redirect is working.
After `status` shows ssl=false: suggest running setup-ssl.
After `status` shows users=0: suggest opening /setup in browser.

## Technical Details (Tier 3)

### Architecture
- **Frontend**: Next.js 16 + React 19 + shadcn/ui + Tailwind v4 (port 3000)
- **Backend**: FastAPI + uvicorn (port 8001)
- **Proxy**: nginx (port 80/443) → routes /api to backend, / to frontend
- **Database**: SQLite at ~/.openclaw/webclaw/webclaw.sqlite

### 8 Generic UI Components
DataTable, FormView, DetailView, ChatPanel, ChartPanel, KanbanBoard, CalendarView, TreeView — all render dynamically from skill action responses.

### Tables Owned
webclaw_user, webclaw_session, webclaw_config, webclaw_role, webclaw_user_role, webclaw_role_permission, chat_session, chat_message, audit_log

### Script Path
```
scripts/db_query.py --action <action-name> [--key value ...]
```

### Per-Skill Customization
Skills can add a `webclaw` section to their SKILL.md frontmatter:
```yaml
webclaw:
  domain: "GRC & Audit"
  database: "~/.openclaw/auditclaw/data.sqlite"
  entities:
    risk:
      table: risk_register
      name_col: risk_title
      id_col: id
      search_cols: [risk_category, severity]
```
