---
name: Web Development
description: Build, debug, and deploy websites with HTML, CSS, JavaScript, modern frameworks, and production best practices.
---

## Quick Reference

| Need | See |
|------|-----|
| HTML/CSS issues | `html-css.md` |
| JavaScript patterns | `javascript.md` |
| React/Next.js/frameworks | `frameworks.md` |
| Deploy to production | `deploy.md` |
| Performance/SEO/a11y | `performance.md` |

## Critical Rules

1. **DOCTYPE matters** — Missing `<!DOCTYPE html>` triggers quirks mode; layouts break unpredictably
2. **CSS specificity beats cascade** — `.class` overrides element selectors regardless of order
3. **`===` not `==`** — Type coercion causes `"0" == false` to be true
4. **Async/await in loops** — `forEach` doesn't await; use `for...of` or `Promise.all`
5. **CORS is server-side** — No client-side fix; configure `Access-Control-Allow-Origin` on the server
6. **Responsive = viewport meta** — Without `<meta name="viewport">`, mobile renders desktop-width
7. **Form without `preventDefault`** — Page reloads; call `e.preventDefault()` in submit handler
8. **Images need dimensions** — Missing `width`/`height` causes layout shift (CLS penalty)
9. **HTTPS or blocked** — Mixed content (HTTP resources on HTTPS pages) gets blocked by browsers
10. **Environment variables leak** — `NEXT_PUBLIC_*` exposes to client; never prefix secrets

## Common Requests

**"Make it responsive"** → Mobile-first CSS with media queries; test at 320px, 768px, 1024px
**"Deploy to production"** → See `deploy.md` for Vercel/Netlify/VPS patterns
**"Fix CORS error"** → Server must send headers; proxy through same-origin if you can't control server
**"Improve performance"** → Lighthouse audit; focus on LCP, CLS, FID; lazy-load below-fold images
**"Add SEO"** → Title/description per page, semantic HTML, OG tags, sitemap.xml

## Framework Decision Tree

- **Static content, fast builds** → Astro or plain HTML
- **Blog/docs with MDX** → Astro or Next.js App Router
- **Interactive app with auth** → Next.js or Remix
- **Full SSR/ISR control** → Next.js
- **Simple SPA, no SEO needed** → Vite + React/Vue
