# Portfolio Report

Address: `{{address}}`
Chain: {{chain}}
Generated: {{timestamp}}

---

## Summary

| Metric | Value |
|--------|-------|
| Total Value (USD) | ${{total_value_usd}} |
| 24h Change | {{change_24h}}% |
| 7d Change | {{change_7d}}% |
| Position Count | {{position_count}} |
| Active Protocols | {{protocol_count}} |

---

## Asset Distribution

### By Type

| Type | Value (USD) | Percentage |
|------|-------------|------------|
| Tokens | ${{tokens_value}} | {{tokens_pct}}% |
| DeFi Positions | ${{defi_value}} | {{defi_pct}}% |
| NFTs | ${{nft_value}} | {{nft_pct}}% |
| **Total** | **${{total_value_usd}}** | **100%** |

### By Asset

{% for asset in assets %}
| {{asset.symbol}} | ${{asset.value_usd}} | {{asset.percentage}}% | {{asset.protocol or 'Wallet'}} |
{% endfor %}

---

## DeFi Positions

{% for position in defi_positions %}
### {{position.protocol}} - {{position.name}}

| Field | Value |
|-------|-------|
| Type | {{position.type}} |
| Deposited | {{position.deposited}} {{position.asset}} (${{position.deposited_usd}}) |
| Current Value | ${{position.current_value_usd}} |
| APY | {{position.apy}}% |
| Rewards | {{position.rewards}} |
| Health Factor | {{position.health_factor}} |

{% if position.expiry %}
**⏰ Expires**: {{position.expiry}} ({{position.days_until_expiry}} days)
{% endif %}

{% endfor %}

---

## Expiring Positions

{% if expiring_positions %}
| Protocol | Position | Expires | Days Left | Value |
|----------|----------|---------|-----------|-------|
{% for pos in expiring_positions %}
| {{pos.protocol}} | {{pos.name}} | {{pos.expiry}} | {{pos.days_left}} | ${{pos.value}} |
{% endfor %}
{% else %}
No positions expiring in the next 30 days.
{% endif %}

---

## Yield Summary

| Source | APY | Value | Annual Yield |
|--------|-----|-------|--------------|
{% for yield in yield_summary %}
| {{yield.source}} | {{yield.apy}}% | ${{yield.value}} | ${{yield.annual_yield}} |
{% endfor %}
| **Total** | **{{weighted_apy}}%** | **${{total_value_usd}}** | **${{total_annual_yield}}** |

---

## Risk Exposure

| Risk Type | Exposure | Details |
|-----------|----------|---------|
| Smart Contract | {{sc_risk}} | {{sc_protocols}} |
| Liquidation | {{liq_risk}} | {{liq_details}} |
| Impermanent Loss | {{il_risk}} | {{il_details}} |
| Oracle | {{oracle_risk}} | {{oracle_details}} |

---

## Recommendations

{% for rec in recommendations %}
{{rec.priority}}. **{{rec.title}}**: {{rec.description}}
{% endfor %}

---

## Transaction History (Last 7 Days)

| Date | Action | Protocol | Amount | Asset |
|------|--------|----------|--------|-------|
{% for tx in recent_transactions %}
| {{tx.date}} | {{tx.action}} | {{tx.protocol}} | {{tx.amount}} | {{tx.asset}} |
{% endfor %}

---

*Report generated by Web3 Investor Skill*