# Investment Opportunity Report

Generated: {{timestamp}}
Chain: {{chain}}

---

## Summary

| Metric | Value |
|--------|-------|
| Protocol | {{protocol_name}} |
| Pool/Contract | {{pool_name}} |
| APY | {{apy}}% |
| TVL | ${{tvl}} |
| Risk Level | {{risk_level}} |
| Lock Period | {{lock_period}} |

---

## Protocol Information

- **Name**: {{protocol_name}}
- **Category**: {{category}}
- **Contract Address**: `{{contract_address}}`
- **Chain**: {{chain}}
- **Audit Status**: {{audit_status}}
- **Live Since**: {{launch_date}}

---

## Risk Assessment

| Factor | Score | Notes |
|--------|-------|-------|
| Protocol Maturity | {{maturity_score}}/3 | {{maturity_notes}} |
| Audit Status | {{audit_score}}/3 | {{audit_notes}} |
| TVL Size | {{tvl_score}}/2 | {{tvl_notes}} |
| Decentralization | {{decentralization_score}}/2 | {{decentralization_notes}} |
| **Total** | **{{risk_score}}/10** | {{risk_level}} |

{% if warnings %}
### ⚠️ Warnings
{% for warning in warnings %}
- {{warning}}
{% endfor %}
{% endif %}

---

## Underlying Assets

{% for asset in underlying_assets %}
- **{{asset.symbol}}**: {{asset.name}} ({{asset.percentage}}%)
{% endfor %}

---

## Yield Breakdown

| Source | APY |
|--------|-----|
| Base APY | {{base_apy}}% |
| Reward APY | {{reward_apy}}% |
| **Total APY** | **{{apy}}%** |

---

## Financial Metrics

| Metric | Value |
|--------|-------|
| Min Deposit | {{min_deposit}} |
| Max Deposit | {{max_deposit}} |
| Withdrawal Fee | {{withdrawal_fee}} |
| Entry Fee | {{entry_fee}} |
| Performance Fee | {{performance_fee}} |

---

## How to Invest

### Step 1: Prepare Wallet
Ensure you have {{required_asset}} in your wallet.

### Step 2: Approve Token
```
approve({{contract_address}}, amount)
```

### Step 3: Deposit
```
deposit(amount, recipient_address)
```

### Contract Call Example
```javascript
// Using ethers.js
const contract = new ethers.Contract(
  '{{contract_address}}',
  ABI,
  signer
);
await contract.deposit(ethers.utils.parseUnits('100', 6));
```

---

## Risk-Adjusted Analysis

| Scenario | APY | Risk Score | Risk-Adjusted APY |
|----------|-----|------------|-------------------|
| Optimistic | {{optimistic_apy}}% | {{risk_score}} | {{optimistic_adjusted}}% |
| Base Case | {{apy}}% | {{risk_score}} | {{base_adjusted}}% |
| Pessimistic | {{pessimistic_apy}}% | {{risk_score}} | {{pessimistic_adjusted}}% |

---

## Recommendation

{{recommendation}}

**Verdict**: {{verdict}} (Risk-Adjusted APY: {{risk_adjusted_apy}}%)

---

*Report generated by Web3 Investor Skill*