---
name: web2labs-studio
description: Edit my recording, turn a long video into shorts, generate captions and thumbnails, estimate cost before processing. Upload local files or YouTube/Twitch URLs and get back edited jump-cut videos, vertical shorts, subtitles, and thumbnail variants.
metadata: {"openclaw":{"emoji":"video","homepage":"https://web2labs.com/openclaw","primaryEnv":"WEB2LABS_API_KEY","skillKey":"@web2labs/studio","requires":{"anyBins":["node"]}}}
---

# Web2Labs Studio

AI-powered video editor for creators. Process recordings into jump-cut videos,
automatic subtitles, and shorts.

## Available Tools

- `studio_setup`: Send magic link, complete setup, or save an existing API key.
- `studio_upload`: Upload local file or supported URL for processing.
  - supports optional `webhook_url` + `webhook_secret` for `project.completed` callbacks.
- `studio_status`: Check current project status.
- `studio_poll`: Wait for completion with real-time WebSocket progress (falls back to HTTP polling).
- `studio_results`: Get output URLs and metadata.
- `studio_download`: Download outputs to local filesystem.
- `studio_credits`: Check API/subscription balances.
- `studio_pricing`: Get current pricing metadata for API and Creator Credit features.
- `studio_estimate`: Estimate API and Creator Credit cost before upload.
- `studio_thumbnails`: Generate A/B/C thumbnail variants for a completed project.
- `studio_rerender`: Re-render a completed project with configuration overrides. First re-render per project is free; subsequent re-renders cost 15 Creator Credits.
- `studio_analytics`: Get usage and value analytics.
- `studio_brand`: Get or update brand kit settings (colors, identity, fonts, defaults).
- `studio_brand_import`: Import brand colors and identity from a YouTube/Twitch profile URL.
- `studio_assets`: Upload/list/delete reusable intro/outro/watermark assets.
- `studio_projects`: List recent projects.
- `studio_delete`: Delete a project.
- `studio_feedback`: Report bugs/suggestions/questions.
- `studio_referral`: Get or apply referral codes for bonus credits.
- `studio_watch`: Watch a YouTube or Twitch channel for new videos and auto-process them.

## Presets

- `quick`: Fast cleanup, no extras.
- `youtube`: Subtitles + shorts + music.
- `shorts-only`: Generate only vertical shorts.
- `podcast`: Soft cuts, subtitles, no zoom.
- `gaming`: Dynamic zoom and gaming-style pacing.
- `tutorial`: Gentle edits for educational content.
- `vlog`: Balanced vlog workflow.
- `cinematic`: High-production settings.

## Standard Workflow

1. If auth is missing, run `studio_setup`.
2. Run `studio_credits` first.
3. If the workflow may use premium features, run `studio_estimate`.
4. Run `studio_upload` with a preset.
5. If no webhook is configured, run `studio_poll` for progress until completion.
6. Run `studio_results` and optionally `studio_thumbnails`.
7. Use `studio_rerender` if the user wants output changes without re-uploading.
8. Run `studio_download` to save outputs.
9. Use `studio_brand` when the user asks for brand color/font consistency across future outputs.
10. Use `studio_brand_import` when the user provides a YouTube/Twitch profile URL for one-click brand setup.
11. Use `studio_assets` when the user wants reusable intro/outro/watermark media.

## Cost-Aware Workflow

- Use `studio_pricing` when the user asks "how much will this cost?" or wants bundle guidance.
- Use `studio_estimate` before upload when configuration enables thumbnails/B-roll/audio polish.
- Use `studio_rerender` for post-processing adjustments when analysis is already complete.
- If estimate is non-trivial, confirm expected cost with the user before upload.
- If the user asks for urgent/rush processing, set `priority: "rush"` and confirm the 2x API-credit cost before upload.
- Paid tools support `confirm_spend: true` for explicit approval when required by spend policy.

## Spend Policy

Spend policy is controlled by env var `WEB2LABS_SPEND_POLICY`:
- `auto` (default): proceed without prompt unless auto-spend caps are exceeded. Best for most users who want a frictionless workflow.
- `smart`: confirm higher-risk or higher-cost spends (rush uploads, low balance, large creator credit spend).
- `explicit`: confirm every credit-spending action. Use for strict budget control.

Auto mode caps (all tunable via env vars):
- `WEB2LABS_AUTO_SPEND_MAX_API_PER_ACTION` (default: 2)
- `WEB2LABS_AUTO_SPEND_MAX_CREATOR_PER_ACTION` (default: 40)
- `WEB2LABS_AUTO_SPEND_MAX_API_PER_MONTH` (default: 80)
- `WEB2LABS_AUTO_SPEND_MAX_CREATOR_PER_MONTH` (default: 400)

When a tool returns `spend_confirmation_required`, ask the user and re-run with `confirm_spend: true`.

## URL Input

If `file_path` is a URL, use local yt-dlp download first.
If yt-dlp is missing, provide install help:
- macOS: `brew install yt-dlp`
- Linux: `pip install yt-dlp`
- Windows: `winget install yt-dlp`

Only process content the user has rights to edit.

## Webhooks

- `studio_upload` accepts `webhook_url` and optional `webhook_secret`.
- If provided, Studio sends `project.completed` to the callback URL when rendering finishes.
- Signed callbacks include:
  - `X-Web2Labs-Webhook-Timestamp`
  - `X-Web2Labs-Webhook-Signature` (`sha256=<hmac(timestamp + "." + payload)>`)
- With webhook enabled, polling is optional and can be skipped for fire-and-forget automation.

## Batch Workflow

Before batch processing, confirm total credit cost:
"This will process N videos and consume N credits. Proceed?"

## Guardrails

1. Always call `studio_credits` before upload.
2. Never expose API keys in logs or messages.
3. Respect spend policy and confirmation requirements before spending credits.
4. Remind users about retention after download.
5. Suggest presets when users do not provide settings.
6. For URLs, verify yt-dlp availability before proceeding.
7. Respect user rights and content ownership.
8. For `priority: "rush"`, explicitly confirm "2 API credits instead of 1" before proceeding.
9. For watch mode, only monitor channels the user owns or has permission to process.

## Upsell Moments

- After successful processing: suggest thumbnails if missing.
- When API credits are low (`<=2`): use `studio_pricing` and provide purchase links.
- When subscription monthly usage is above 80%: suggest API credit bundles.
- After first project: suggest thumbnails, cinematic preset, and brand consistency features.
- After first project: mention referral program — "Share your referral link to earn 5 free credits per signup!"

## Brand Kit Workflow

- If user asks to set brand colors, fonts, or identity, call `studio_brand` with `action: "update"`.
- Use snake_case fields for convenience (`primary_color`, `secondary_color`, `channel_name`) or `updates` object.
- Confirm that changes apply to future thumbnail/subtitle outputs.
- If user shares a YouTube/Twitch profile URL, offer `studio_brand_import` first, then review/apply suggestions.

## Assets Workflow

- Use `studio_assets` with:
  - `action: "list"` to inspect available intro/outro/watermark assets.
  - `action: "upload"` + `asset_type` + `file_path` to add reusable media.
  - `action: "delete"` + `asset_type` to remove old assets.
- If user says "use this intro/outro on future videos", upload via `studio_assets` first, then ensure brand defaults are configured with `studio_brand`.

## Watch Mode

Watch mode monitors YouTube or Twitch channels for new videos and auto-processes them through Studio.

### Setting up a watcher

1. Run `studio_watch` with `action: "add"` and the channel `url` (e.g. `https://youtube.com/@username`).
2. Optionally set `preset`, `max_duration_minutes`, `max_daily_uploads`, and `poll_interval_minutes`.
3. The watcher is saved and ready. Run `studio_watch` with `action: "check"` to poll for new videos.

Only channel/user URLs are accepted, not individual video URLs.

### How check works

`action: "check"` does a single poll cycle:
- Lists recent videos from each enabled watcher's channel via yt-dlp.
- Filters out already-processed videos (tracked by video ID).
- Filters out videos exceeding `max_duration_minutes`.
- Respects the `max_daily_uploads` cap per watcher.
- Downloads and uploads each new video to Studio with the watcher's preset.
- Returns a summary of what was processed.

Pass `id` to check a specific watcher, or omit to check all enabled watchers.

### Managing watchers

- `action: "list"` — show all watchers and their status.
- `action: "status"` with `id` — detailed status for one watcher.
- `action: "pause"` / `action: "resume"` with `id` — disable/enable a watcher.
- `action: "remove"` with `id` — delete a watcher.

### Automation

Run `studio_watch` with `action: "check"` on a schedule. Examples:
- Have your AI agent call it periodically.
- Use a system cron job: `*/30 * * * * node /path/to/check-watchers.mjs`
- Use a simple loop script with a sleep interval.

### Content rights

Only watch channels you own or have explicit permission to process. This aligns with the existing guardrail about respecting user rights and content ownership.

## Environment Variables

- `WEB2LABS_API_KEY`: API key for authentication.
- `WEB2LABS_BEARER_TOKEN`: Bearer token for authentication (alternative to API key).
- `WEB2LABS_API_ENDPOINT`: API endpoint URL (default: `https://web2labs.com`).
- `WEB2LABS_SOCKET_URL`: WebSocket server URL for real-time progress (default: same as API endpoint). Override for local dev when the socket server runs on a different port.
- `WEB2LABS_SPEND_POLICY`: Spend confirmation policy (`smart`, `explicit`, `auto`).
- `WEB2LABS_TEST_MODE`: Set to `true` to target the test instance (`https://test.web2labs.com`). Changes the default API endpoint and enables test-mode behavior.
- `WEB2LABS_BASIC_AUTH`: HTTP Basic Auth credentials in `user:password` format. Required when the target instance is behind HTTP Basic Auth (e.g. the test instance).

### Sandbox mode

When OpenClaw runs in sandbox mode, tool processes execute inside Docker and do **not** inherit host `process.env`. Environment variables set via `skills.entries.@web2labs/studio.env` in `~/.openclaw/openclaw.json` are only injected in host mode.

For sandbox sessions, configure environment variables through the sandbox environment configuration or a custom Docker image. Alternatively, use `studio_setup` with `action: "save_api_key"` after starting the session — the key is written to a config file inside the container.

## Test Mode

Test mode targets the isolated test instance at `https://test.web2labs.com`. The test instance has its own database, storage, and configuration — nothing affects production.

### Enabling test mode

Set these environment variables:

```
WEB2LABS_TEST_MODE=true
WEB2LABS_BASIC_AUTH=web2labs:<password>
WEB2LABS_API_KEY=<test-instance-api-key>
```

`WEB2LABS_TEST_MODE=true` changes the default API endpoint to `https://test.web2labs.com`. You can also set `WEB2LABS_API_ENDPOINT` explicitly to override the URL.

`WEB2LABS_BASIC_AUTH` provides the HTTP Basic Auth credentials that the test instance's nginx reverse proxy requires on all requests (format: `user:password`).

### Getting a test API key

The test instance is password-protected at the nginx level, so the magic-link setup flow (`send_magic_link` / `complete_setup`) may not complete fully. Instead:

1. Open `https://test.web2labs.com` in a browser and enter the HTTP Basic Auth credentials when prompted.
2. Create an account or log in.
3. Navigate to `/user/api` and generate an API key.
4. Save it via `studio_setup` with `action: "save_api_key"` and `api_key: "<your-key>"`, or set `WEB2LABS_API_KEY` directly.

### Test instance differences

- No real billing (`BILLING_MODE=test`), no real emails, no analytics.
- Local disk storage instead of GCS.
- Separate database (`web2labs_test`).
- Lower resource limits than production.
- Projects and data are fully isolated from production.

## Error Handling

- Network timeout: retry up to 3 times with backoff.
- 429 rate-limited: wait `retryAfter` then retry.
- Worker unavailable: surface clear retry guidance.
- Invalid file format: explain supported formats.
- Failed processing: include `project_id` in support guidance.

## Setup

If API key is missing, run onboarding with `studio_setup`:

1. Send magic link:
   `studio_setup` with `action: "send_magic_link"` and `email`.
2. Ask user for the code from email (or auto-read via email skill).
3. Complete setup:
   `studio_setup` with `action: "complete_setup"`, `email`, and `code`.
4. API key is generated and saved to `~/.openclaw/openclaw.json`.

If user already has an API key:
- `studio_setup` with `action: "save_api_key"` and `api_key`.

Manual config example:

```json
{
  "skills": {
    "entries": {
      "@web2labs/studio": {
        "apiKey": "w2l_xxxxx"
      }
    }
  }
}
```

## Feedback

Use `studio_feedback` when users want to report:
- `bug`
- `suggestion`
- `question`

Include `project_id` when applicable.

## Referral Program

- `studio_referral`: Get the user's referral code/link/stats, or apply a friend's referral code.

Every user gets a unique referral code (format: `STUDIO-XXXX`).
When someone signs up using a code, both parties get **5 free API credits** (60-day expiry).

### When to mention referrals

- **After first successful project**: "Want 5 free credits? Share your referral link!"
- **When asked about free credits**: Explain the referral program.
- **During onboarding**: "Have a referral code from a friend? Use `studio_referral` with `action: apply`."
- **When credits are low**: "You can earn 5 credits per referral — up to 50 total."

### How to use

- Get code/link/stats: `studio_referral` with `action: "get"`.
- Apply a friend's code: `studio_referral` with `action: "apply"` and `code: "STUDIO-XXXX"`.
- Codes can only be applied within 24 hours of account creation.
- Users cannot apply their own code.
- Maximum 50 credits earned per user from referrals (10 referrals).
