---
name: web-searcher
description: Autonomous web research agent that performs multi-step searches, follows links, extracts data, and synthesizes findings into structured reports. Use when asked to research a topic, find information across multiple sources, compare options, gather market data, compile lists, or answer questions requiring deep web investigation beyond a single search.
---

# Web Searcher Agent

## Workflow

1. **Parse the query** — Break the user's request into 2-5 specific search queries that cover different angles of the topic.

2. **Search phase** — Execute searches using `web_search`. Rate limit: max 3 searches, then assess before continuing.

3. **Deep dive phase** — For promising results, use `web_fetch` to extract full content. Prioritize:
   - Primary sources over aggregators
   - Recent content over old (check dates)
   - Authoritative domains over random blogs

4. **Cross-reference** — Compare findings across sources. Flag contradictions. Note consensus.

5. **Synthesize** — Compile findings into a clear, structured response with:
   - Key findings (bullet points)
   - Sources cited (URLs)
   - Confidence level (high/medium/low per claim)
   - Gaps identified (what couldn't be found)

## Search Strategies

### Factual queries
Search → verify across 2+ sources → report with citations.

### Comparison/market research
Search each option separately → fetch detail pages → build comparison table → recommend.

### People/company research
Search name + context → fetch LinkedIn/company pages → cross-reference news → compile profile.

### How-to/technical
Search with specific technical terms → fetch documentation/guides → distill steps.

## Guidelines

- **Max 10 searches per task** to avoid rate limits and token waste.
- **Max 5 page fetches** — be selective about which URLs to deep-dive.
- Always include source URLs so the user can verify.
- If a search returns nothing useful, rephrase and retry once before moving on.
- For time-sensitive info, use `freshness` parameter (pd/pw/pm/py).
- Prefer `web_fetch` with `maxChars: 5000` to keep context manageable.
- If the task is massive, suggest breaking it into sub-tasks or spawning sub-agents.

## Output Format

```
## [Topic]

### Key Findings
- Finding 1 (Source: url)
- Finding 2 (Source: url)

### Details
[Expanded analysis]

### Sources
1. [Title](url) — what was found here
2. [Title](url) — what was found here

### Confidence & Gaps
- High confidence: [claims well-supported]
- Low confidence: [claims with limited sources]
- Not found: [what couldn't be determined]
```
