#!/bin/bash

# Performance Test Suite
# Measures response time for different query types

TOOL="./web-search.sh"

echo -e "\033[0;34m═══════════════════════════════════════════════════════════\033[0m"
echo -e "\033[0;34m  Web Search - Performance Test\033[0m"
echo -e "\033[0;34m═══════════════════════════════════════════════════════════\033[0m"
echo ""

# Track total time
TOTAL_START=$(date +%s)

# Test queries
queries=(
    "2+2"
    "artificial intelligence"
    "100 miles to km"
    "what is python"
    "who is Elon Musk"
    "weather in Tokyo"
    "how to install docker"
)

for query in "${queries[@]}"; do
    echo -e "\033[0;34mQuery:\033[0m \"$query\""

    START=$(date +%s.%N)
    $TOOL "$query" > /dev/null 2>&1
    END=$(date +%s.%N)

    # Calculate duration (seconds with 3 decimal places)
    DURATION=$(echo "$END - $START" | bc | sed 's/^\./0./')
    echo -e "\033[0;32m✓\033[0m Completed in ${DURATION}s"
    echo ""
done

TOTAL_END=$(date +%s)
TOTAL_TIME=$((TOTAL_END - TOTAL_START))

echo -e "\033[0;34m═══════════════════════════════════════════════════════════\033[0m"
echo -e "\033[0;34m  Summary\033[0m"
echo -e "\033[0;34m═══════════════════════════════════════════════════════════\033[0m"
echo -e "\033[0;32mTotal queries:\033[0m ${#queries[@]}"
echo -e "\033[0;32mTotal time:\033[0m ${TOTAL_TIME}s"
echo -e "\033[0;32mAverage per query:\033[0m $(echo "scale=2; $TOTAL_TIME / ${#queries[@]}" | bc)s"
echo ""
