---
name: web-search
description: Web search using DuckDuckGo Instant Answer API (no API key required). Use when you need to search the web for information, definitions, calculations, conversions, or quick facts. Also use when user mentions "search", "look up", "find information", "what is", "how to", or "google something". The skill provides instant answers, definitions, abstracts, and related topics without requiring external API credentials.
---

# Web Search

Free web search using DuckDuckGo's Instant Answer API. No API key required.

## Quick Start

```bash
# Basic search
cd /home/hxx/clawd/tools && ./web-search.sh "your query"

# Examples
./web-search.sh "what is artificial intelligence"
./web-search.sh "python programming"
./web-search.sh "define recursion"
./web-search.sh "2+2"
```

## Command-Line Options

### Core Options
- `-h, --help` - Display help message with usage examples
- `--format <format>` - Output format: `text`, `markdown`, `plain` (default: `text`)
  - `text`: Colored terminal output (default)
  - `markdown`: Clean markdown format (no ANSI colors)
  - `plain`: Plain text without colors
- `--no-color` - Disable colored output (same as `--format plain`)
- `--max-related <N>` - Control number of related topics to show (default: 5)
- `--quiet` - Minimal output mode (just results, no headers/footer)

### Output to File
Use shell redirection to save results to file:

```bash
# Save to file
./web-search.sh "query" > output.txt

# With markdown format
./web-search.sh --format markdown "query" > results.md

# With no colors for logs
./web-search.sh --no-color "query" > search.log
```

## What It Returns

The tool provides several result types:

- **Answers** - Direct answers for calculations, conversions, weather, etc.
- **Abstracts** - Wikipedia-style summaries with source and URL
- **Definitions** - Word/term definitions
- **Related Topics** - Additional relevant results (configurable, 5 default)

## Best Practices

1. **Be specific** - More specific queries get better instant answers
2. **Try variations** - If no results, rephrase your query
3. **Use for facts** - Definitions, calculations, quick lookups work best
4. **Check URL** - Always provides DuckDuckGo link for full search
5. **Use appropriate format**:
   - Terminal output: `--format text` (colored, default)
   - Documentation: `--format markdown` > file.md`
   - Logs/piping: `--format plain` or `--no-color`

## Limitations

- No full web search results (only instant answers)
- Some queries return limited results depending on DuckDuckGo's data
- Character encoding issues in some abstracts (known limitation)
- Requires internet access to query DuckDuckGo API
- Not all query types return instant answers (e.g., complex math like `sqrt(144)`)
- Definitions may not always be available for all terms
- Recent news may not appear (DuckDuckGo focuses on evergreen content)

## Usage Examples

### Basic Search
```bash
# Simple query
./web-search.sh "open source AI models"

# Wikipedia-style query
./web-search.sh "what is recursion"
```

### Markdown Format
```bash
# Clean markdown output
./web-search.sh --format markdown "python programming"

# Save to markdown file
./web-search.sh --format markdown "AI research" > research.md
```

### Plain/No Color
```bash
# For logs or piping
./web-search.sh --format plain "search query"

# Disable colors explicitly
./web-search.sh --no-color "search query"
```

### Control Related Topics
```bash
# Show fewer related topics
./web-search.sh --max-related 3 "machine learning"

# Show more related topics
./web-search.sh --max-related 10 "open source"
```

### Quiet Mode
```bash
# Minimal output (just results)
./web-search.sh --quiet "what is 42 + 7"
```

### Combined Options
```bash
# Markdown, no color, saved to file
./web-search.sh --format markdown --no-color "topic" > results.md

# Quiet with custom related count
./web-search.sh --quiet --max-related 2 "definition"
```

## Tested Scenarios

Tested and verified to work:
- ✅ Calculations: `2+2`, `10% of 500`
- ✅ Conversions: `100 miles to km`
- ✅ Wikipedia queries: `what is artificial intelligence`
- ✅ Programming: `what is python`, `how to install docker`
- ✅ People: `who is Elon Musk`
- ✅ Scientific facts: `speed of light`
- ✅ Weather: `weather in Tokyo`
- ✅ Edge cases: empty queries, special characters, no results
- ✅ Output formats: text, markdown, plain
- ✅ Flags: --help, --format, --no-color, --max-related, --quiet

See [test-outputs.md](test-outputs.md) for detailed test results.

## Troubleshooting

### "No direct results found"
Try rephasing your query or using the provided DuckDuckGo URL for full search.

### Network errors
Check internet connection. Tool requires network access.

### Character encoding issues
Some abstracts display garbled characters. This is a known issue with basic parsing (install `jq` for better results).

### "jq not found" warning
The tool works without `jq` using basic text extraction, but installing `jq` improves JSON parsing:
```bash
# Ubuntu/Debian
sudo apt-get install jq

# macOS
brew install jq

# Via package managers
npm install -g jq
```

## Output Format

### Text Format (default)
- **Blue** - Headers and search info
- **Green** - Result markers and content
- **Yellow** - Sources, URLs, and warnings
- **Red** - Errors

Use `--format plain` or `--no-color` to disable colors.

### Markdown Format
Clean markdown with:
- `##` headers for sections
- `**bold**` for emphasis
- `-` bullet lists
- `*italics*` for metadata
- `[links]()` for URLs

### Plain Format
No ANSI codes or markdown formatting - suitable for logs and piping.

## Requirements

- `curl` or `wget` (for HTTP requests)
- Optional: `jq` (for better JSON parsing)
