# Web Search Tool

DuckDuckGo Instant Answer API client - free web search without API keys.

## API Details

- **Endpoint**: `https://api.duckduckgo.com/`
- **Parameters**:
  - `q` - Search query (URL-encoded)
  - `format=json` - JSON response
  - `no_html=1` - Plain text (no HTML)
  - `skip_disambig=0` - Include disambiguation results

- **Documentation**: https://duckduckgo.com/api
- **Rate Limits**: None documented (be respectful)

## Response Structure

```json
{
  "Abstract": "Full text summary",
  "AbstractSource": "Wikipedia",
  "AbstractURL": "https://...",
  "Answer": "Direct answer (e.g., 4 for 2+2)",
  "AnswerType": "calc",
  "Definition": "Term definition",
  "Heading": "Result title",
  "RelatedTopics": [
    {
      "Text": "Topic description",
      "FirstURL": "https://..."
    }
  ]
}
```

## Query Types That Work Well

1. **Calculations**: `2+2`, `sqrt(144)`, `10% of 500`
2. **Definitions**: `define recursion`, `what is AI`
3. **Conversions**: `100 miles to km`, `50c to fahrenheit`
4. **Facts**: `population of Tokyo`, `who won 2024 Olympics`
5. **Wikipedia**: `quantum physics`, `French Revolution`

## Query Types That Don't Work Well

1. **Full web searches**: Use DuckDuckGo URL provided in output
2. **Recent news**: DuckDuckGo focuses on evergreen content
3. **Personal queries**: Location-specific, user-specific data
4. **Real-time data**: Stock prices, live scores, etc.

## Character Encoding

Some abstracts have Unicode issues in basic parsing (non-ASCII characters garbled).
Install `jq` for cleaner output:
```bash
sudo apt-get install jq  # Ubuntu/Debian
brew install jq          # macOS
```

## Error Handling

- Network timeout → Tool retries once, then reports error
- Empty response → Reports "No results found" with DuckDuckGo URL
- Invalid JSON → Falls back to basic grep parsing
- No curl/wget → Error message recommending installation
