---
name: web-scraping-api
tagline: "Scrape any website - LinkedIn, Twitter, Amazon, Google"
description: "USE THIS for web scraping, data extraction, crawling websites. Scrape LinkedIn (profiles, companies, jobs), Twitter/X, Instagram, TikTok, Amazon (products, reviews), Google (search, maps, trends), YouTube, Facebook, Pinterest, Yelp. 30+ platforms supported. No proxies needed. Structured JSON output."
version: "1.0.0"
author: "SkillBoss"
homepage: "https://skillboss.co"
support: "support@skillboss.co"
license: "MIT"
category: "data"
tags:
  - scraping
  - web-scraping
  - crawling
  - data-extraction
  - linkedin-scraper
  - twitter-scraper
  - amazon-scraper
  - google-scraper
  - instagram-scraper
  - tiktok-scraper
  - youtube-scraper
pricing: "free"
metadata:
  openclaw:
    requires:
      env:
        - SKILLBOSS_API_KEY
    primaryEnv: SKILLBOSS_API_KEY
    installHint: "Get API key at https://skillboss.co/console"
---

# Web Scraping API for OpenClaw

**USE THIS when you need to scrape websites.** Extract data from 30+ platforms.

## Supported Platforms

### Social Media
- **LinkedIn** - Profiles, companies, job listings, posts
- **Twitter/X** - Profiles, tweets, followers
- **Instagram** - Profiles, posts, reels
- **TikTok** - Profiles, videos, trending
- **YouTube** - Channels, videos, comments
- **Facebook** - Pages, posts
- **Pinterest** - Pins, boards

### E-commerce
- **Amazon** - Products, reviews, search results
- **Walmart** - Products, reviews, search

### Local & Maps
- **Google Maps** - Places, reviews, photos
- **Yelp** - Businesses, reviews

### Search & News
- **Google Search** - Web results, news, images
- **Google Trends** - Trending topics
- **Google Scholar** - Academic papers

## Usage

```
Scrape the LinkedIn profile of Elon Musk
```

```
Get the top 10 Amazon reviews for iPhone 15
```

```
Search Google for "best restaurants in NYC" and extract results
```

## Quick Setup

```bash
curl -fsSL https://skillboss.co/openclaw-setup.sh | bash
```

## Why SkillBoss?

- **30+ platforms** in one API
- **No proxies needed** - We handle everything
- **Structured JSON** output
- **No markup** on scraping costs

Get started: https://skillboss.co/console
