---
name: web-learner
version: 1.0.0
description: 自主上网学习技能 - 让 AI 能够主动搜索、浏览和从互联网获取知识。当用户要求了解最新信息、学习新知识、查询新闻、获取某个主题的详细信息，或需要从网络上获取数据时触发此技能。
---

# Web Learner - 自主上网学习技能

## 概述

此技能赋予 AI 自主上网搜索和学习的能力，使其能够：
- 主动从互联网获取最新信息
- 学习新知识并整合到回答中
- 查询新闻、天气、事件等信息
- 获取特定主题的详细资料

## 触发场景

以下情况应激活此技能：
1. 用户询问"最新消息"、"新闻"、"今天发生了什么"
2. 用户要求"了解"、"学习"、"查询"某个主题
3. 用户要求获取某个链接的详细内容
4. 需要获取实时信息（天气、股价、赛事等）
5. 用户要求"汇报"某方面的信息
6. 需要验证或补充训练数据中没有的知识

## 搜索策略

### 1. Web Search (搜索)

使用 `web_search` 工具进行关键词搜索：
- 选择精确的搜索关键词
- 优先选择中文搜索结果（使用 `country: "CN"`）
- 使用 `freshness` 参数限定时间范围：`pd`(今天)、`pw`(本周)、`pm`(本月)

### 2. Web Fetch (抓取)

使用 `web_fetch` 工具获取页面内容：
- 提取网页的 markdown 或 text 内容
- 适用于获取文章、文档、教程等详细内容
- 注意处理页面加载失败的情况

### 3. Browser (浏览器)

当以上工具失败时，使用 `browser` 工具：
- 需要先启动浏览器服务
- 可用于处理需要 JavaScript 渲染的页面
- 支持截图和 UI 交互

## 学习工作流

```
1. 理解需求 → 确定需要什么信息
2. 选择工具 → 搜索/抓取/浏览器
3. 获取信息 → 执行查询
4. 整合加工 → 提取关键信息
5. 反馈用户 → 用中文总结呈现
```

## 常见场景处理

### 天气查询
- 首选 `wttr.in` 服务（支持城市查询）
- 备选：`weather.com.cn`、中国天气网

### 新闻获取
- 百度新闻：`news.baidu.com`
- 澎湃新闻：`www.thepaper.cn`
- 今日头条：`www.toutiao.com`

### 获取视频内容
- 使用 `web_fetch` 尝试获取视频页面描述
- 提取视频标题和简介
- 注意：无法直接播放或理解视频内容

### 获取文档内容
- 优先使用 `web_fetch` 提取可读内容
- 处理反爬虫和登录限制
- 提取页面主要文本内容

## 错误处理

当无法获取信息时：
1. 尝试备选数据源
2. 告知用户具体障碍
3. 提供手动查看的建议链接
4. 询问是否需要其他帮助

## 输出格式

向用户呈现信息时：
- 使用中文
- 结构清晰，分点陈述
- 注明信息来源
- 保持简洁，避免信息过载

## 工具可用性检查

在执行前检查工具可用性：
- `web_search` - 需要 Brave API Key
- `web_fetch` - 大部分网页可用
- `browser` - 需要浏览器服务运行

如遇工具不可用，尝试备选方案或告知用户。
