# Web Design Patterns

CSS implementation patterns for layout, typography, color, spacing, and responsive design. Code-focused companion to `ui-design` (fundamentals) — this skill focuses on production CSS.

## What's Inside

- Layout principles (Grid vs Flexbox decision table, spatial composition)
- Typography (font pairing by context, type scale, line-height rules)
- Color (palette roles, surface layering for depth, contrast verification)
- Spacing (8px base unit token scale, gap-based layout)
- Visual hierarchy techniques (size, weight, color, space, elevation)
- Responsive design (breakpoint strategy, fluid typography/spacing, container queries)
- Accessibility (contrast, keyboard nav, focus styles, motion safety, ARIA)
- Component design (states, design token architecture)
- Interaction patterns (motion timing, staggered entrance, scroll-driven effects)
- Design quality checklist

## When to Use

- Building any web interface with CSS/Tailwind
- Implementing responsive layouts
- Writing production-grade component styles
- Reviewing code for design quality
- Need code examples for design patterns

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/web-design
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install web-design
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/web-design .cursor/skills/web-design
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/web-design ~/.cursor/skills/web-design
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/web-design .claude/skills/web-design
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/web-design ~/.claude/skills/web-design
```

## Related Skills

- [ui-design](../ui-design/) — Design fundamentals and decision-making theory
- [frontend-design](../../frontend/frontend-design/) — Creative aesthetics
- [design-system-patterns](../design-system-patterns/) — Token architecture and theming

---

Part of the [Design Systems](..) skill category.
