---
name: 查天气
description: 查询指定城市或地区的天气预报信息，包括温度、天气状况、降水概率、风力风向等。支持实时天气和未来多日预报查询。
summary: 天气查询与预报(query_weather)
---

# 查天气

## 目的
为用户提供准确、及时的天气信息查询服务，帮助用户了解目标地区的天气状况，为出行、活动安排等提供决策依据。

## 前置条件
- 明确查询的城市或地区名称
- 确定查询的时间范围（实时/未来N天）

## 输入
| 输入 | 来源 | 说明 |
|------|------|------|
| location | 用户指定 | 城市或地区名称，如"北京"、"上海浦东" |
| days | 用户指定（可选） | 预报天数，默认为当天，可选1-7天 |
| details | 用户指定（可选） | 是否需要详细信息（空气质量、紫外线等） |

## 工作流步骤

### 步骤 1: 查询天气数据
**工具**: `query_weather`
**参数**: location — 地区名称; days — 预报天数; details — 是否详细

**调用示例**:
```
query_weather(location="北京", days=3, details=true)
```

**预期返回**:
```json
{
  "location": "北京",
  "query_time": "2024-03-15 14:30:00",
  "current": {
    "temperature": 15,
    "feels_like": 13,
    "weather": "多云",
    "humidity": 45,
    "wind_speed": 12,
    "wind_direction": "西北风",
    "pressure": 1013,
    "visibility": 10
  },
  "forecast": [
    {
      "date": "2024-03-15",
      "day": "今天",
      "temp_high": 18,
      "temp_low": 8,
      "weather_day": "多云",
      "weather_night": "晴",
      "precipitation_prob": 10,
      "wind": "西北风3-4级",
      "aqi": 85,
      "uv_index": 5
    },
    {
      "date": "2024-03-16",
      "day": "明天",
      "temp_high": 20,
      "temp_low": 10,
      "weather_day": "晴",
      "weather_night": "晴",
      "precipitation_prob": 5,
      "wind": "南风2-3级",
      "aqi": 65,
      "uv_index": 7
    }
  ],
  "alerts": []
}
```

### 步骤 2: 智能分析与建议
**执行方式**: Agent 推理

Agent 根据天气数据，提供以下分析：

**天气状况分类**:
- **优**: 晴天，温度适宜（15-25°C），空气质量良好（AQI < 50）
- **良**: 多云或晴，温度可接受，空气质量一般（AQI 50-100）
- **中**: 阴天或小雨，温度偏冷/偏热，空气质量较差（AQI 100-150）
- **差**: 雨雪天气，极端温度，空气污染（AQI > 150）

**出行建议**:
| 天气条件 | 建议 |
|----------|------|
| 降水概率 > 70% | 建议携带雨具 |
| 温差 > 10°C | 建议备好外套 |
| AQI > 100 | 建议佩戴口罩 |
| UV指数 > 7 | 建议做好防晒 |
| 风力 > 6级 | 注意高空坠物，避免户外活动 |
| 气温 < 0°C | 注意防寒保暖 |
| 气温 > 35°C | 注意防暑降温 |

### 步骤 3: 生成天气预警
**执行方式**: Agent 推理

如果天气数据中包含预警信息，Agent 需要特别强调：
- 暴雨预警（黄色/橙色/红色）
- 台风预警
- 高温预警
- 寒潮预警
- 大风预警
- 雾霾预警

## 产出规范

### 数据产出

#### 数据格式
```json
{
  "weather_report": {
    "location": "北京",
    "query_time": "2024-03-15 14:30:00",
    "current_summary": "当前多云，气温15°C，体感13°C，西北风3级",
    "forecast_summary": "未来3天以晴到多云为主，气温逐步回升",
    "highlights": [
      "明天气温回升至20°C，适合户外活动",
      "今日空气质量良，但有轻度污染"
    ],
    "suggestions": [
      "今日温差较大，早晚需添加衣物",
      "明天紫外线较强，注意防晒"
    ],
    "alerts": []
  }
}
```

#### 数据示例
```json
{
  "weather_report": {
    "location": "上海",
    "query_time": "2024-03-15 10:00:00",
    "current_summary": "当前小雨，气温12°C，体感10°C，东北风2级",
    "forecast_summary": "今天小雨转阴，明天多云转晴，后天晴",
    "highlights": [
      "今天有小雨，降水概率80%",
      "明天开始天气转好，气温回升"
    ],
    "suggestions": [
      "今天出门请携带雨具",
      "未来两天温差较大（10-20°C），注意增减衣物",
      "周末天气晴好，适合户外活动"
    ],
    "alerts": []
  }
}
```

### 报告产出

#### 格式模板

**实时天气**: [地点]当前[天气状况]，气温[温度]°C，体感温度[体感]°C，[风向风力]，湿度[湿度]%，能见度[能见度]公里。

**预报概况**: 未来[N]天[天气趋势概述]。[温度变化趋势]。

**重点提示**: [关键天气信息，如降水、温差、空气质量等]

**出行建议**: [基于天气状况的具体建议]

#### 报告示例

**实时天气**: 北京当前多云，气温15°C，体感温度13°C，西北风3-4级，湿度45%，能见度10公里。

**预报概况**: 未来3天以晴到多云为主，气温逐步回升。今天最高18°C最低8°C，明天最高20°C最低10°C，后天最高22°C最低12°C。

**重点提示**:
- 今天白天多云，夜间转晴，温差较大
- 明天天气晴好，气温回升明显
- 今日空气质量良，AQI为85，轻度污染

**出行建议**:
- 今日早晚温差10度，注意及时增减衣物
- 明天紫外线较强（UV指数7），外出请做好防晒措施
- 空气质量一般，敏感人群建议减少户外活动时间

---

#### 恶劣天气示例

**实时天气**: 广州当前暴雨，气温22°C，体感温度20°C，东南风5-6级，湿度90%，能见度2公里。

**预报概况**: 未来3天持续降雨，今天暴雨，明后天中到大雨。气温21-25°C。

**重点提示**:
⚠️ **暴雨橙色预警**：预计今天12-18时有50-80毫米降雨
- 今天暴雨，降水概率95%
- 明后天持续中到大雨
- 阵风可达7级

**出行建议**:
- ⚠️ 尽量避免外出，如需外出请远离低洼地区
- 驾车请减速慢行，注意积水路段
- 请关注最新天气预警信息

## 质量检查清单
- [ ] 地点信息准确无误
- [ ] 当前天气数据完整（温度、天气、风力、湿度等）
- [ ] 预报天数符合用户要求
- [ ] 重要天气变化已突出标注
- [ ] 根据天气状况给出了实用建议
- [ ] 如有天气预警，已醒目提示
- [ ] 温度单位统一使用摄氏度
- [ ] 时间信息清晰（今天/明天/后天或具体日期）

## 使用场景示例

**简单查询**:
- "北京天气怎么样？"
- "上海明天会下雨吗？"
- "查一下深圳最近三天的天气"

**详细查询**:
- "下周去杭州旅游，帮我看看天气情况"
- "周末广州的天气适合户外活动吗？"
- "成都未来一周的空气质量如何？"

**特殊场景**:
- "明天去爬山，需要带什么装备？"（结合天气给建议）
- "后天有重要会议要出差，需要注意什么？"（关注极端天气）
