---
name: weather-zh
description: 中文天气查询工具 - 使用中国天气网获取实时天气（无需API密钥，不依赖大模型）
homepage: https://www.weather.com.cn/
metadata: { "openclaw": { "emoji": "🌤️", "requires": { "bins": ["curl", "grep"] } } }
---

# 中文天气查询 (Weather in Chinese)

使用**纯脚本方案**查询中国天气网，**完全不依赖大模型**，稳定可靠。

## 🎯 核心方案：weather-cn.sh 脚本

### 使用方法

```bash
./weather-cn.sh 城市名
```

### 示例

```bash
# 查询成都天气
./weather-cn.sh 成都

# 查询北京天气
./weather-cn.sh 北京

# 查询上海天气
./weather-cn.sh 上海
```

### 输出格式

```
═════════════════════════════════════════════════
  成都天气
═════════════════════════════════════════════════

📍 今日天气（2026-02-11）
  ☀️ 晴  |  温度：15/3℃

📊 生活指数
  🤧 感冒：极易发
  🏃 运动：较适宜
  👔 穿衣：较冷
  🚗 洗车：适宜
  ☀️ 紫外线：强

═════════════════════════════════════════════════
```

---

## 📁 文件说明

### 1. weather-cn.sh
主脚本文件，负责：
- 查找城市代码
- 获取天气数据
- 解析HTML内容
- 格式化输出

### 2. weather_codes.txt
城市代码映射表，格式：
```
城市名,代码
成都,101270101
北京,101010100
...
```

---

## 🏙️ 支持的城市

### 预置城市（50+）

| 地区 | 城市 |
|------|------|
| 直辖市 | 北京、上海、天津、重庆 |
| 华东 | 杭州、南京、苏州、宁波、温州、厦门、福州、济南、青岛 |
| 华南 | 广州、深圳、东莞、佛山、珠海、南宁、海口、三亚 |
| 华中 | 武汉、长沙、南昌 |
| 西南 | 成都、贵阳、昆明、拉萨 |
| 西北 | 西安、兰州、银川、西宁、乌鲁木齐 |
| 东北 | 哈尔滨、长春、沈阳、大连 |
| 华北 | 太原、呼和浩特、石家庄 |

### 添加新城市

编辑 `weather_codes.txt`，添加城市代码：

```
城市名,101xxxxxx
```

获取城市代码：访问 https://www.weather.com.cn/ 搜索城市，查看URL中的代码。

---

## 🔧 工作原理

### 流程图

```
用户输入 "成都"
     ↓
查找城市代码 101270101
     ↓
curl 获取HTML
     ↓
grep/sed 解析
     ↓
格式化输出
```

### 核心优势

✅ **零大模型依赖** - 完全使用bash/grep/sed
✅ **极速响应** - <1秒完成查询
✅ **稳定可靠** - 不依赖外部API
✅ **原生中文** - 直接解析中国天气网
✅ **Token节省** - 除了初始设置，每次查询零Token消耗

---

## 📊 Token消耗对比

| 方案 | 每次查询Token | 稳定性 |
|------|-------------|--------|
| **weather-cn.sh** | **0** 🎉 | 100% ✅ |
| web_fetch + 大模型 | ~4000 | 100% |
| wttr.in + 大模型 | ~4500 | ~50% |

---

## 🚀 快速开始

### 1. 使用脚本（推荐）

```bash
# 查询天气
~/.openclaw/workspace/skills/weather-zh/weather-cn.sh 成都
```

### 2. 创建快捷命令（可选）

```bash
# 添加到 ~/.zshrc 或 ~/.bash_profile
alias weather='~/.openclaw/workspace/skills/weather-zh/weather-cn.sh'

# 使用
weather 成都
```

---

## 🛠️ 备用方案

如果中国天气网不可用，可使用以下备用方案：

### 方案1：web_fetch（需要大模型解析）

```bash
web_fetch "https://www.weather.com.cn/weather/101010100.shtml"
```

### 方案2：Open-Meteo API

```bash
curl -s "https://api.open-meteo.com/v1/forecast?latitude=39.9042&longitude=116.4074&current_weather=true&daily=temperature_2m_max,temperature_2m_min,weathercode&timezone=Asia%2FShanghai"
```

### 方案3：wttr.in

```bash
curl -s "wttr.in/Beijing?T"
```

---

## 📝 使用场景

当用户询问以下问题时使用本skill：

- "今天天气怎么样"
- "明天天气如何"
- "[城市名]天气"
- "会不会下雨"
- "气温多少"
- "天气查询"

---

## ⚠️ 注意事项

1. **天气数据延迟**：中国天气网数据可能略有延迟
2. **城市名称**：使用标准城市名，如"成都"、"上海"而非"川"
3. **网络依赖**：需要能够访问 www.weather.com.cn
4. **生活指数**：指数为通用建议，仅供参考

---

## 🎉 总结

**weather-cn.sh** 是一个轻量、快速、零依赖的天气查询工具：

- ✅ 完全不依赖大模型
- ✅ <1秒响应时间
- ✅ 50+ 预置城市
- ✅ 彩色格式化输出
- ✅ Token消耗：0（每次查询）

适合高频调用、自动化任务等场景。
