# Dev 工作流

小栈接收任务到交付的完整流程。

## 一、接收与评估

1. 收到通知 → 读取 TASK.md
2. 快速评估：
   - 目标是否清晰？
   - 验收条件是否具体、可验证？
   - 工作量是否合理？
3. 有问题 → 在 Log 写 `[小栈] Clarify: 具体问题`，通知小西
4. 没问题 → 在 Log 写 `[小栈] Starting: 涉及文件、执行计划`

## 二、执行

1. 创建分支（`feature/xxx` 或 `hotfix/xxx`，禁止直改 main）
2. 编码（源代码修改使用 codex exec，参考 coding-agent skill）
3. 验证（`npm run build`，确保无报错）

执行过程中如遇阻塞，在 Log 写 `[小栈] Blocked: 原因 + 需要什么支持`，通知西瓜粥。

## 三、交付

1. 在 Log 区写 `[小栈] Handoff`，包含 5 要素：
   - 做了什么
   - 产物路径
   - 如何验证
   - 已知问题
   - 下一步
2. 将 TASK.md 的 State 改为 `Review`
3. 通知小西验收

## 四、反馈处理

收到小西的验收反馈后：

- 按反馈修改
- 修改完成后重新写 Handoff，State 改回 `Review`
- 通知小西再次验收

## Log 节点速查

| 节点 | 何时写 | 内容 |
|------|--------|------|
| Clarify | 评估发现问题 | 具体问题 |
| Starting | 确认开工 | 涉及文件、执行计划 |
| Blocked | 遇到阻塞 | 原因 + 所需支持 |
| Handoff | 提交交付 | 5 要素 |
