# Task 拆解指南

## 拆解思路

拿到一个 Epic 后，按以下顺序思考：

1. **这个 Epic 的最终交付物是什么？** 明确终态。
2. **要达到终态，需要哪些独立的功能点？** 每个功能点就是一个候选 Task。
3. **每个候选 Task 能否在 1-2 个工作周期内完成？** 不能则继续拆。
4. **每个 Task 能否独立验证？** 不能则调整边界。

## 常见拆解模式

### 按功能层拆

适合 UI 类需求：

```
Epic: 农场种植系统
├── Task: 地块网格布局与选中交互
├── Task: 种子选择面板 UI
├── Task: 播种动画与状态更新
├── Task: 作物生长阶段渲染
└── Task: 收获交互与奖励结算
```

### 按技术层拆

适合前后端分离的需求：

```
Epic: 用户登录系统
├── Task: 后端 OAuth 接口对接
├── Task: 前端登录页面 UI
├── Task: 登录态持久化与自动续期
└── Task: 未登录状态的路由守卫
```

### 按用户流程拆

适合交互链路长的需求：

```
Epic: 商品购买流程
├── Task: 商品列表展示
├── Task: 商品详情页
├── Task: 加入购物车
├── Task: 结算与支付
└── Task: 订单确认页
```

## 粒度检查清单

派发前逐条检查：

- [ ] 只有一个交付物？
- [ ] 验收条件写了具体操作步骤？
- [ ] 预估工作量不超过 1-2 个周期？
- [ ] 不依赖其他未完成的 Task？
- [ ] Dev 看完能直接开工，不需要再猜？

全部打勾才能派发。有一条不满足就继续拆或补充。

## 常见错误

| 错误 | 后果 | 修正 |
|------|------|------|
| 一个 Task 包含多个功能点 | 验收时部分通过部分不通过，扯皮 | 拆成多个 Task |
| 验收条件写"功能正常" | Dev 和 PM 对"正常"理解不同 | 写具体操作步骤和预期结果 |
| Task 之间有隐含依赖 | 后面的 Task 因前面没做完而卡住 | 明确依赖关系或调整顺序 |
| 工作量估计过大 | Dev 长时间无产出，风险不可控 | 拆到每个 Task 有阶段性产出 |
