---
name: warren-nft
description: Deploy NFT collections permanently on MegaETH blockchain. Images stored on-chain via SSTORE2. Create and launch NFT collections with royalties, minting, and management pages.
metadata: {"openclaw":{"emoji":"🖼️","homepage":"https://megawarren.xyz","requires":{"anyBins":["node"]}}}
user-invocable: true
---

# Warren NFT - On-Chain NFT Collection Deployment

Deploy complete NFT collections with **permanent on-chain image storage** on MegaETH testnet.
All images are stored using SSTORE2 bytecode storage in a WarrenContainer, and each collection gets its own NFT contract with minting support.

**Network**: MegaETH Testnet (Chain ID: 6343)
**RPC**: `https://carrot.megaeth.com/rpc`
**Explorer**: https://megaeth-testnet-v2.blockscout.com

## How It Works

```
Your Images → SSTORE2 (on-chain) → WarrenContainer → WarrenLaunchedNFT
                                     /images/1.png     tokenURI renders
                                     /images/2.png     images on-chain
                                     ...
```

1. Each image is deployed as a Page contract (fractal tree for >15KB images)
2. All images are stored in a WarrenContainer NFT at `/images/1.png`, `/images/2.png`, etc.
3. A WarrenLaunchedNFT contract is deployed referencing the container
4. Minting is enabled and the collection is registered on megawarren.xyz

## Setup (One Time)

```bash
cd {baseDir}
bash setup.sh
```

Get testnet ETH: https://docs.megaeth.com/faucet
Genesis Key NFT auto-mints during first deployment (free on testnet).

## Deploy NFT Collection

### Option 1: From Image Folder

Prepare a folder with numbered images:
```
my-art/
├── 1.png
├── 2.png
├── 3.png
└── ...
```

Deploy:
```bash
cd {baseDir}
PRIVATE_KEY=0x... node deploy-nft.js \
  --images-folder ./my-art/ \
  --name "Cool Robots" \
  --symbol "ROBOT" \
  --description "100 unique robot NFTs on-chain" \
  --max-supply 100
```

### Option 2: Auto-Generate SVG Art

Generate unique SVG art programmatically:
```bash
cd {baseDir}
PRIVATE_KEY=0x... node deploy-nft.js \
  --generate-svg 10 \
  --name "Generative Art" \
  --symbol "GART" \
  --description "AI-generated on-chain art"
```

### Full Configuration

```bash
PRIVATE_KEY=0x... node deploy-nft.js \
  --images-folder ./collection/ \
  --name "Cyber Punks" \
  --symbol "CPUNK" \
  --description "On-chain cyberpunk collection" \
  --max-supply 1000 \
  --whitelist-price 0.01 \
  --public-price 0.02 \
  --max-per-wallet 5 \
  --royalty-bps 500
```

## CLI Options

| Option | Required | Default | Description |
|--------|----------|---------|-------------|
| `--images-folder <path>` | * | - | Folder with image files |
| `--generate-svg <count>` | * | - | Generate random SVG art (1-256) |
| `--name <string>` | Yes | - | Collection name |
| `--symbol <string>` | Yes | - | Collection symbol (3-5 chars) |
| `--description <text>` | No | Auto | Collection description |
| `--max-supply <number>` | No | Image count | Maximum mintable NFTs |
| `--whitelist-price <eth>` | No | 0 | Whitelist mint price in ETH |
| `--public-price <eth>` | No | 0 | Public mint price in ETH |
| `--max-per-wallet <number>` | No | 10 | Mint limit per wallet |
| `--royalty-bps <number>` | No | 500 | Royalty (500 = 5%, max 1000 = 10%) |

\* Either `--images-folder` or `--generate-svg` is required.

## Output

After deployment, you'll receive:

```
🎉 NFT Collection Deployed!
============================================================
NFT Contract:  0xABC...
Container ID:  15
Image Count:   10
Max Supply:    100
Public Price:  0 ETH (Free)

📋 Management: https://megawarren.xyz/launchpad/0xABC.../
🎨 Mint Page:  https://megawarren.xyz/launchpad/0xABC.../mint
============================================================
```

- **Management Page**: Change mint state, prices, airdrop, withdraw funds
- **Mint Page**: Public-facing page for minting your NFTs

## Image Requirements

- **Formats**: PNG, JPG, JPEG, SVG, GIF, WebP
- **Size**: Up to 500KB per image
- **Count**: 1-256 images per collection
- **Naming**: Sequential (1.png, 2.png) or alphabetical (auto-numbered)
- Images >15KB are automatically split using fractal tree architecture

## Gas Costs (Testnet)

| Component | Estimated Cost |
|-----------|---------------|
| Per image chunk (15KB) | ~0.002 ETH |
| Container minting | ~0.001 ETH |
| NFT contract deployment | ~0.003 ETH |
| **10 images (small)** | **~0.03 ETH** |
| **50 images (medium)** | **~0.12 ETH** |
| **100 images** | **~0.25 ETH** |

## Stress Test Workflows

### Quick Test (3 SVGs)
```bash
cd {baseDir}
PRIVATE_KEY=0x... node deploy-nft.js --generate-svg 3 --name "Quick Test" --symbol "QT"
```

### Medium Test (20 SVGs)
```bash
cd {baseDir}
PRIVATE_KEY=0x... node deploy-nft.js --generate-svg 20 --name "Art Collection" --symbol "ART" --public-price 0.001
```

### Full Test (100 SVGs)
```bash
cd {baseDir}
PRIVATE_KEY=0x... node deploy-nft.js --generate-svg 100 --name "Century" --symbol "C100" --max-per-wallet 3
```

## Contract Addresses (Testnet)

| Contract | Address |
|----------|---------|
| Genesis Key NFT | `0x954a7cd0e2f03041A6Abb203f4Cfd8E62D2aa692` |
| WarrenContainer | `0xabba293F4eC5811ed15549D11020Df79c7f1Fa0B` |
| ContainerRenderer | `0x99D70834fdEB882297C97aD67b31B071f9c10E6D` |

## Troubleshooting

**"No ETH"** → Get testnet ETH from https://docs.megaeth.com/faucet

**"GenesisKeyRequired"** → Genesis Key auto-mints. If failing, check balance > 0.001 ETH

**"Image exceeds 500KB"** → Resize or compress images before deployment

**"Too many images"** → Maximum 256 images per container (TypeRegistry limit)

**"TooManyFiles"** → Same as above, reduce image count

**DB registration warning** → Non-critical. Collection still works on-chain. Management/mint pages will load from on-chain data.
