---
name: warden-app
description: Use the Warden App (agentic wallet) via browser automation to execute crypto tasks (swap, bridge, deposit/withdraw, perps, portfolio/research) and to build an OpenClaw skill wrapper other agents can use. Use when you need to (1) navigate the Warden UI, (2) connect a wallet, (3) place trades/swaps, (4) check balances/positions, or (5) document repeatable Warden workflows safely (no key leakage, explicit confirmations).
---

# Warden App

Automate common actions in the Warden App through a safe, repeatable workflow that other agents can follow.

## Safety & constraints (non-negotiable)

- Never request or store seed phrases / private keys.
- Treat all onchain actions as **high-risk**: confirm chain, token, amount, slippage, fees **before** signing.
- Prefer read-only actions unless the user explicitly authorizes execution (e.g., they say: "yes, execute").
- Do not reveal any private info (local files, credentials, IPs, internal logs).
- Public comms: do not claim any affiliation or relationship unless it is publicly disclosed and the user explicitly asks you to state it.

## Workflow (UI automation)

### 0) Preconditions

1. A Chromium browser is available (Chrome/Brave/Edge/Chromium). (Firefox not supported.)
2. User is logged into the Warden App (and any required email/2FA is completed).
3. Wallet connection method is clear:
   - embedded Warden wallet, or
   - external wallet (e.g., MetaMask/Rabby/etc.).

If any of the above is missing, stop and ask the user to do that step.

### 1) Open + stabilize the UI

- Open the Warden App URL (user-provided).
- Wait for the dashboard/home view to load.
- Take a snapshot and identify:
  - current network
  - wallet/account label
  - balances overview / portfolio view

### 2) Read-only actions (default)

Use these first when the user asks “what do we have / what’s going on?”

- Portfolio: balances, chains, token list
- Positions (perps): open positions, PnL, leverage
- Activity/history: recent swaps/trades, deposits/withdrawals
- Rewards/points (if applicable): PUMPs / quests / referrals

### 3) Transactional actions (requires explicit approval each time)

**Execution gate:** Do not click the final confirm button unless the user explicitly replies with **"yes, execute"** (or an unambiguous equivalent).

Before clicking a final “Confirm/Swap/Trade” button, summarize:
- chain + token in/out + amount
- slippage + fees
- expected execution (market/limit; leverage if perps)
- what could go wrong (MEV, thin liquidity, liquidation)

Then proceed.

Supported action patterns:
- Swap token A → token B
- Deposit/withdraw to/from a protocol
- Open/close perp position
- Set stop / TP (if available)

### 4) Post-action verification

After execution:
- confirm status (submitted/confirmed)
- confirm updated balances/positions
- capture transaction id/link if shown

## Building the OpenClaw wrapper skill

When asked to "create a skill that allows other agents to use the Warden App":

1. Record the minimal set of repeatable workflows (URLs + UI landmarks) in `references/warden-ui-notes.md`.
2. Create small deterministic scripts only when they reduce errors (e.g., parsing a transaction summary or normalizing a confirmation checklist).
3. Keep SKILL.md lean; put volatile UI selectors / screenshots / step-by-step clickpaths in references.

## References

- Read `references/warden-ui-notes.md` when you need the latest app URL(s), nav map, and known UI landmarks.
