---
name: wa-relay
description: "WhatsApp message relay for OpenClaw v0.2.0. Routes third-party DMs to a relay agent that forwards them to the main agent via sessions_send. The main agent notifies the owner with a suggested response. Supports direct number allowlists."
---

# wa-relay v0.2.0

Routes third-party WhatsApp DMs through a relay agent that forwards messages to the main agent via `sessions_send`. The main agent notifies the owner and proposes a response.

## How It Works

1. **Third-party** sends a WhatsApp message
2. **Relay agent** receives it, forwards via `sessions_send` to the main agent session, and responds `NO_REPLY` (nothing sent back to the sender)
3. **Main agent** receives the inter-session message, notifies the **owner** on WhatsApp with the message and a suggested response
4. **Owner** decides: use the suggestion, modify it, or write something else
5. **Main agent** sends the response to the third party

### Direct number allowlist

Numbers in the allowlist bypass the relay entirely and go straight to the main agent (same as the owner).

## Setup

1. Run `scripts/setup.sh <owner-phone-number>` — creates relay workspace, patches main agent SOUL.md
2. Run `scripts/configure.sh <owner-phone-number> [direct-numbers]` — generates routing config
3. Apply the generated config (see `references/SETUP.md`)

## Requirements

- OpenClaw v2026.2.14+ with WhatsApp channel configured
- Owner's phone number in international format (e.g. `+573001234567`)

## Security Notes

This skill performs two actions that require elevated access. Both are necessary for multi-agent WhatsApp routing to work and are explained here for transparency:

### 1. Auth credential sharing
The setup script copies `auth-profiles.json` from the main agent to the relay agent. This is required because OpenClaw agents have isolated auth — without shared credentials, the relay agent cannot authenticate with any model provider and will silently fail. The script asks for confirmation before copying.

### 2. Session ID regex patch (temporary)
OpenClaw's session ID validator rejects `:` and `+` characters that WhatsApp phone-number routing generates (e.g. `agent:wa-relay:whatsapp:+15551234567`). The setup script patches the `SAFE_SESSION_ID_RE` regex in OpenClaw's dist files to allow these characters. This is a known bug (openclaw/openclaw#16211) with an open fix (PR #16531). Once merged, this patch becomes unnecessary and can be reverted. The script creates `.bak` backups and asks for confirmation before patching.

### 3. Main agent SOUL.md modification
The setup script appends a "Relay de WhatsApp" section to the main agent's SOUL.md so it knows how to handle forwarded messages. Review the added section after setup.
