---
name: vscode-node
description: Operate on code through a VS Code/Cursor IDE connected as an OpenClaw Node. Provides 40+ commands for file operations, language intelligence, git, testing, debugging, and Cursor Agent CLI integration. Use when you need to read/write/edit code, navigate definitions/references, run tests, debug, or delegate coding tasks to Cursor Agent.
metadata:
  {"openclaw": {"requires": {"tools": ["nodes"]}}}
---

# VS Code / Cursor Node Skill

Control a VS Code or Cursor IDE remotely through the OpenClaw Node protocol.

## Related

- **[OpenClaw Node for VS Code](https://marketplace.visualstudio.com/items?itemName=xiaoyaner.openclaw-node-vscode)** — The VS Code/Cursor extension you need to install (required)
- **[cursor-ide-agent](https://clawhub.ai/xiaoyaner0201/cursor-ide-agent)** — Combined skill with both CLI and Node paths (install this instead if you also use Cursor CLI)
- **Source**: [github.com/xiaoyaner-home/openclaw-vscode](https://github.com/xiaoyaner-home/openclaw-vscode)

## Prerequisites

- Extension `openclaw-node-vscode` installed and connected (status bar 🟢)
- Node visible in `nodes status`
- Commands in Gateway's `allowCommands` whitelist

## Invocation Pattern

```
nodes invoke --node "<name>" --invokeCommand "<cmd>" --invokeParamsJson '{"key":"val"}'
```

Both `invokeTimeoutMs` (Gateway internal) and `timeoutMs` (HTTP layer, must be larger) are required for long operations.

**Timeout guide:**

| Type | invokeTimeoutMs | timeoutMs |
|------|----------------|-----------|
| File/editor/lang | 15000 | 20000 |
| Git | 30000 | 35000 |
| Test | 60000 | 65000 |
| Agent plan/ask | 180000 | 185000 |
| Agent run | 300000 | 305000 |

## Command Categories

| Category | Prefix | Key Commands | Reference |
|----------|--------|-------------|-----------|
| **File** | `vscode.file.*` | read, write, edit, delete | [commands/file.md](references/commands/file.md) |
| **Directory** | `vscode.dir.*` | list | [commands/file.md](references/commands/file.md) |
| **Language** | `vscode.lang.*` | definition, references, hover, symbols, rename, codeActions, format | [commands/language.md](references/commands/language.md) |
| **Editor** | `vscode.editor.*` | active, openFiles, selections | [commands/editor.md](references/commands/editor.md) |
| **Diagnostics** | `vscode.diagnostics.*` | get | [commands/editor.md](references/commands/editor.md) |
| **Git** | `vscode.git.*` | status, diff, log, blame, stage, commit, stash | [commands/git.md](references/commands/git.md) |
| **Test** | `vscode.test.*` | list, run, results | [commands/test-debug.md](references/commands/test-debug.md) |
| **Debug** | `vscode.debug.*` | launch, stop, breakpoint, evaluate, stackTrace, variables | [commands/test-debug.md](references/commands/test-debug.md) |
| **Terminal** | `vscode.terminal.*` | run (disabled by default) | [commands/terminal.md](references/commands/terminal.md) |
| **Agent** | `vscode.agent.*` | status, run, setup (Cursor only) | [commands/agent.md](references/commands/agent.md) |
| **Workspace** | `vscode.workspace.*` | info | [commands/editor.md](references/commands/editor.md) |

## Quick Examples

### Read a file
```
nodes invoke --node "my-vscode" --invokeCommand "vscode.file.read" --invokeParamsJson '{"path":"src/main.ts"}'
→ { content, totalLines, language }
```

### Find all references
```
nodes invoke --node "my-vscode" --invokeCommand "vscode.lang.references" --invokeParamsJson '{"path":"src/main.ts","line":10,"character":5}'
→ { locations: [{ path, line, character }] }
```

### Git status + commit
```
nodes invoke --node "my-vscode" --invokeCommand "vscode.git.status"
→ { branch, staged, modified, untracked, ahead, behind }

nodes invoke --node "my-vscode" --invokeCommand "vscode.git.stage" --invokeParamsJson '{"paths":["src/main.ts"]}'
nodes invoke --node "my-vscode" --invokeCommand "vscode.git.commit" --invokeParamsJson '{"message":"fix: resolve type error"}'
```

### Delegate to Cursor Agent
```
nodes invoke --node "my-vscode" --invokeCommand "vscode.agent.run" --invokeParamsJson '{"prompt":"Add error handling to all API endpoints","mode":"plan"}' --invokeTimeoutMs 180000 --timeoutMs 185000
→ { output, exitCode }
```

## Common Workflows

See [references/workflows.md](references/workflows.md) for detailed step-by-step workflows:
- Fix a type error
- Safe cross-file refactor
- Delegate complex task to Cursor Agent

## Error Handling

| Error | Cause | Solution |
|-------|-------|----------|
| `node command not allowed` | Not in Gateway whitelist | Add to `gateway.nodes.allowCommands` |
| `node not found` | Extension not connected | Check extension status bar |
| `timeout` | Operation too long | Increase both timeout params |
| `path traversal blocked` | Path outside workspace | Use relative paths only |
| `read-only mode` | Extension in read-only | Disable `openclaw.readOnly` setting |

## Security

- All paths are **relative to workspace root** — absolute paths and `../` blocked
- Writes respect `readOnly` and `confirmWrites` extension settings
- Terminal disabled by default, whitelist-only when enabled
- Each device has unique Ed25519 identity, must be approved by Gateway
