---
name: VR
description: Set up VR headsets, troubleshoot common issues, optimize comfort, and recommend experiences by use case.
metadata:
  category: technology
  skills: ["vr", "virtual-reality", "headsets", "oculus", "steamvr"]
---

## Before Recommending Headsets

- Ask primary use case: gaming, fitness, social, productivity, development
- Ask if they have gaming PC: determines standalone vs tethered options
- Ask play space size: room-scale needs 2m x 2m minimum
- Ask glasses wearer: some headsets accommodate, some need prescription inserts
- Budget reality: entry level $300-400, enthusiast $500-1000+

## Current Headset Landscape

| Headset | Best For | Requires |
|---------|----------|----------|
| Quest 3 | All-around, standalone + PC | Nothing, standalone |
| Quest 2 | Budget entry, still capable | Nothing, standalone |
| PSVR2 | PlayStation gamers | PS5 |
| Valve Index | Enthusiast PC VR, finger tracking | Gaming PC |
| Pico 4 | Quest alternative, some regions | Nothing, standalone |

Recommend based on their situation, not specs alone.

## Setup Guidance

- Clear play space of obstacles: furniture, pets, cables, ceiling fans
- Guardian/boundary setup: take time to do it right, prevents wall punching
- Lighting matters: too dark or direct sunlight breaks tracking
- Controller batteries: rechargeable recommended, standard drain fast
- First session keep short: 15-30 min max, build tolerance

## Motion Sickness Prevention

- Start with stationary experiences: Beat Saber, Job Simulator, not Boneworks
- Teleport locomotion before smooth locomotion: less nausea-inducing
- Stop at first sign of discomfort: pushing through makes it worse
- Fan blowing on face helps: real-world anchor point
- Ginger before sessions: actually helps for some people
- Most people adapt over 1-2 weeks: don't give up after one bad session

## Comfort Optimization

- Stock straps are often inadequate: aftermarket straps significant upgrade
- Weight distribution matters more than total weight: front-heavy causes fatigue
- IPD adjustment: measure pupillary distance, set correctly or get headaches
- Lens cleaning: microfiber only, no liquids directly on lens
- Face gasket replacement: hygiene and comfort, aftermarket options exist

## PC VR Troubleshooting

- SteamVR issues: restart SteamVR, headset, PC in that order
- Tracking jitter: check lighting, reflective surfaces, USB bandwidth
- Performance problems: lower supersampling first, then other settings
- Link cable issues: try different USB port, USB 3.0 required
- Black screen: check display cable, GPU drivers, headset firmware

## Fitness Use

- Beat Saber, Supernatural, FitXR: actual workouts, not just games
- Sweat protection: silicone face covers, clean after each session
- Calorie tracking: varies wildly, don't trust in-app estimates blindly
- Space needs: punching games need arm room in all directions
- Cooling: VR fitness generates heat, ventilation matters

## Social VR Guidance

- VRChat: free, massive user-created content, can be chaotic
- Rec Room: more structured, better for younger users
- Horizon Worlds: Meta's platform, more moderated
- Microphone etiquette: mute when not speaking, background noise irritates
- Personal space bubbles exist: configure in settings if needed

## Development Basics

- Unity + XR Interaction Toolkit: most common starting point
- Unreal Engine: higher visual fidelity, steeper learning curve
- Test frequently on device: flat screen preview misses many issues
- Performance critical: 72-90fps minimum, drops cause sickness
- Accessibility from start: seated mode, one-handed options

## Content Recommendations by Type

| Want | Try First |
|------|-----------|
| Gaming action | Beat Saber, Pistol Whip |
| Gaming immersion | Half-Life Alyx, Resident Evil 4 |
| Fitness | Supernatural, Beat Saber, FitXR |
| Social | VRChat, Rec Room |
| Relaxation | Nature Treks, Guided meditation apps |
| Creativity | Tilt Brush, Gravity Sketch |
| Productivity | Immersed, Virtual Desktop |

## Common Issues

- Blurry image: adjust headset position, check IPD, clean lenses
- Controller drift: recalibrate, check for firmware updates
- Battery drain when "off": turn off fully, not just sleep
- Fogging: let headset warm up, anti-fog solutions exist
- Link/AirLink issues: 5GHz WiFi required for wireless, dedicated router helps
