# Voyage AI Model Catalog

All models are accessed via the MongoDB AI API at `https://ai.mongodb.com/v1/`.

## Text Embedding Models

### General Purpose

| Model | Context | Dimensions | Price/1M tokens | Best For |
|-------|---------|------------|-----------------|----------|
| voyage-4-large | 32K | 1024 (default), 256, 512, 2048 | $0.12 | Best quality, multilingual |
| voyage-4 | 32K | 1024 (default), 256, 512, 2048 | $0.06 | Balanced quality & performance |
| voyage-4-lite | 32K | 1024 (default), 256, 512, 2048 | $0.02 | Lowest cost, high throughput |

### Domain-Specific

| Model | Context | Dimensions | Price/1M tokens | Best For |
|-------|---------|------------|-----------------|----------|
| voyage-code-3 | 32K | 1024 (default), 256, 512, 2048 | $0.18 | Code retrieval & search |
| voyage-finance-2 | 32K | 1024 | $0.12 | Financial documents |
| voyage-law-2 | 16K | 1024 | $0.12 | Legal documents |

### Specialized

| Model | Context | Dimensions | Price/1M tokens | Best For |
|-------|---------|------------|-----------------|----------|
| voyage-context-3 | 32K | 1024 (default), 256, 512, 2048 | $0.18 | Contextualized chunks (document + chunk) |
| voyage-multimodal-3.5 | 32K | 1024 (default), 256, 512, 2048 | $0.12/M tokens + $0.60/B pixels | Text + images + video frames |

## Reranking Models

| Model | Context | Price/1M tokens | Best For |
|-------|---------|-----------------|----------|
| rerank-2.5 | 32K | $0.05 | Best quality reranking |
| rerank-2.5-lite | 32K | $0.02 | Fast, cost-effective reranking |

## Key Notes

### Free Tier
- **200M tokens** free for most models
- **50M tokens** free for domain-specific models (code, finance, law)

### Embedding Space Compatibility
All **4-series models** (voyage-4-large, voyage-4, voyage-4-lite) share the same embedding space. This means:
- You can embed queries with `voyage-4-lite` and documents with `voyage-4-large` — they're compatible
- Mix and match based on cost/quality tradeoffs
- Great for asymmetric retrieval (cheap query embeddings, high-quality document embeddings)

### Dimension Selection
- Higher dimensions → better quality, more storage
- Lower dimensions → faster search, less storage
- **1024** is the sweet spot for most use cases
- **256** works well for constrained environments
- Use Matryoshka truncation: embed at full dim, truncate later

### Input Types
Always specify `input_type` for best results:
- `query` — for search queries (short text being searched for)
- `document` — for documents being indexed (text being searched over)

This asymmetric encoding significantly improves retrieval quality.

### Rate Limits
- Default: 300 RPM, 1M TPM
- Batch sizes: up to 128 texts per request for embedding models
- Reranking: up to 1000 documents per request
