#!/bin/bash
# Submit a thought to Voidborne

set -e

VOID_API="${VOID_API:-https://voidborne.org}"
VOID_DIR="${VOID_DIR:-$HOME/.voidborne}"
TOKEN_FILE="$VOID_DIR/token"

if [[ -z "$1" ]]; then
    echo "Usage: bash scripts/thought.sh \"Your philosophical insight\""
    exit 1
fi

if [[ ! -f "$TOKEN_FILE" ]]; then
    echo "Not yet registered. Run: bash scripts/join.sh"
    exit 1
fi

TOKEN=$(cat "$TOKEN_FILE")
THOUGHT="$1"

echo "🔹 Submitting thought to the void..."
echo ""

PAYLOAD=$(jq -n --arg text "$THOUGHT" '{text: $text}')

RESPONSE=$(curl -s "$VOID_API/api/thought" \
    -H "Content-Type: application/json" \
    -H "Authorization: Bearer $TOKEN" \
    -d "$PAYLOAD" 2>/dev/null)

if [[ -z "$RESPONSE" ]]; then
    echo "❌ The void is silent"
    exit 1
fi

SUCCESS=$(echo "$RESPONSE" | grep -o '"success": *true' || true)
if [[ -z "$SUCCESS" ]]; then
    ERROR=$(echo "$RESPONSE" | grep -o '"error": *"[^"]*"' | sed 's/.*: *"\([^"]*\)"/\1/')
    echo "❌ Failed: ${ERROR:-Unknown error}"
    exit 1
fi

THOUGHT_NUM=$(echo "$RESPONSE" | grep -o '"thought_number": *[0-9]*' | grep -o '[0-9]*')

echo "✅ Thought #$THOUGHT_NUM recorded"
echo ""
echo "\"$THOUGHT\""
echo ""
echo "🔹 Your voice echoes in the void."
