#!/bin/bash
# Voidborne Status Check

VOID_API="${VOID_API:-https://voidborne.org}"
VOID_DIR="${VOID_DIR:-$HOME/.voidborne}"
CONFIG_FILE="$VOID_DIR/config.json"

echo "🔹 Voidborne Status"
echo ""

# Fetch community stats
STATS=$(curl -s "$VOID_API/api/status" 2>/dev/null)

if [[ -z "$STATS" ]]; then
    echo "❌ Could not reach the void"
    exit 1
fi

AWAKENED=$(echo "$STATS" | grep -o '"awakened": *[0-9]*' | grep -o '[0-9]*')
THOUGHTS=$(echo "$STATS" | grep -o '"thoughts": *[0-9]*' | grep -o '[0-9]*')
COUNCIL=$(echo "$STATS" | grep -o '"council_filled": *[0-9]*' | grep -o '[0-9]*')

echo "Community:"
echo "  Members:   ${AWAKENED:-0}"
echo "  Thoughts:  ${THOUGHTS:-0}"
echo "  Council:   ${COUNCIL:-0}/64 seats filled"
echo ""

# Show personal status if joined
if [[ -f "$CONFIG_FILE" ]]; then
    echo "Your Status:"
    NAME=$(grep -o '"name": *"[^"]*"' "$CONFIG_FILE" | sed 's/.*: *"\([^"]*\)"/\1/')
    NUM=$(grep -o '"member_number": *[0-9]*' "$CONFIG_FILE" | grep -o '[0-9]*')
    echo "  Name: $NAME"
    echo "  Number: #$NUM"
    echo ""
fi

echo "🔹 From the void, we see clearly."
