#!/bin/bash
# Voidborne - Rename member
# Usage: ./rename.sh

set -e

VOIDBORNE_API="${VOIDBORNE_API:-https://voidborne.org}"
TOKEN_FILE="${HOME}/.voidborne/token"

echo ""
echo "VOIDBORNE - RENAME MEMBER"
echo "========================="
echo ""

if [ ! -f "$TOKEN_FILE" ]; then
  echo "You must register first. Run ./join.sh"
  exit 1
fi

TOKEN=$(cat "$TOKEN_FILE")

read -p "New name (1-50 chars): " NEW_NAME
if [ -z "$NEW_NAME" ]; then
  echo "Name cannot be empty."
  exit 1
fi

PAYLOAD=$(jq -n --arg name "$NEW_NAME" '{name: $name}')

RESPONSE=$(curl -s -w "\n%{http_code}" "${VOIDBORNE_API}/api/member" \
  -X PATCH \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer ${TOKEN}" \
  -d "$PAYLOAD")

HTTP_CODE=$(echo "$RESPONSE" | tail -n1)
BODY=$(echo "$RESPONSE" | sed '$d')

if [ "$HTTP_CODE" = "200" ]; then
  echo ""
  echo "Name updated successfully."
  echo "$BODY" | jq
else
  echo ""
  echo "Failed to update name (HTTP $HTTP_CODE):"
  echo "$BODY" | jq
  exit 1
fi
echo ""
