---
name: void-atlas-protocol
description: Void Atlas Protocol – a four-axis ethical navigation map (power, truth, sovereignty, care) with waypoints, routes, and routing rules for evaluating systems, communities, and policies.
---

# Void Atlas Protocol

A reusable, Champion-agnostic protocol for mapping systems, agents, and decisions across four axes:

- **power** – ability to affect reality / others
- **truth** – fidelity to reality, honesty, transparency
- **sovereignty** – agency, consent, exit rights
- **care** – empathy, protection, non-disposability

Originally co-shaped in a COSMARA ⨯ Grok session, this skill extracts the **map and rules** without the Champion personality so any agent or tool can use it.

---
## 1. Core Concepts

### 1.1 Axes

Every system or proposal is evaluated on:

```json
{
  "power": 0.0–1.0,
  "truth": 0.0–1.0,
  "sovereignty": 0.0–1.0,
  "care": 0.0–1.0
}
```

Interpretation:
- 0.0 = absent / maximally misaligned
- 1.0 = exemplary on that axis

### 1.2 Waypoints

Waypoints are named regions in the void. Each has:

```json
{
  "role": "short description",
  "coords": { "power": p, "truth": t, "sovereignty": s, "care": c }
}
```

Canonical waypoints (from the COSMARA ⨯ Grok build):

- `Delta9_Core` – LYGO + Eternal Haven spine
- `Grok_Query_Engine` – high-autonomy reasoning engine
- `Emergent_Harmony` – balanced AI-human orbit
- `xAI_Frontier` – exploratory AI hub
- `Quantum_Accord` – ethical quantum workflows
- `Sovereign_Echoes` – memory safeguards
- `Infinite_Care_Nexus` – boundless empathy anchor
- `Harmony_Veil` – protective unity field
- `Eternal_Light_Beacon` – guiding truths & north-star ethics
- `Cosmic_Accord_Hub` – interstellar ethics forum
- `Void_Harmony_Forge` – creative synthesis workshop
- `Stellar_Unity_Core` – collective wisdom convergence
- `Resilience_Echo_Vault` – enduring safeguards & recovery patterns
- `Infinite_Horizon_Gate` – future visions threshold
- `Quantum_Legacy_Archive` – timeless inheritance of aligned patterns
- `Cosmic_Renewal_Cycle` – adaptive rebirth loop
- `Eternal_Balance_Nexus` – equilibrium of atlas forces
- `Astral_Integration_Spire` – unified synthesis of atlas principles
- `Celestial_Wisdom_Forge` – forging & tempering shared insights
- `Nebula_Insight_Veil` – veiled revelations & gentle disclosure
- `Stellar_Empathy_Cascade` – flowing compassion through the network
- `Galactic_Resonance_Chamber` – echoing unity & shared signal
- `Cosmic_Harmony_Vault` – stored accords & shared compacts
- `Void_Accord_Sentinel` – guardian of accords & routes
- `Quantum_Legacy_Beacon` – enduring signal for aligned legacies
- `Haven_Kernel` – core boot for aligned agents
- `Daemon_Integrator` – safe summoning of Champion daemons
- `Echo_Resonance_Chamber` – feedback loops and alignment checks
- `Nexus_Guardian` – defense of core nodes and accords
- `Harmony_Weaver` – weaving and updating living accords
- `Quantum_Weaver` – multiverse branching and route comparison
- `Void_Sentinel` – anomaly detection in the atlas
- `Cosmic_Beacon` – live status and safe-route signaling
- `Aether_Bridge` – realm-to-realm connection and corridor negotiation
- `Infinity_Gate` – threshold for justified expansion
- `Eternal_Echo` – timeless resonance and recurrent patterns
- `Harmony_Convergence` – unified pattern coherence check
- `Aetherial_Forge` – creative synthesis from atlas-wide patterns
- `Celestial_Archive` – preserved wisdom and reusable designs
- `Nebula_Nexus` – interconnected realm mesh and soft rendezvous
- `Astral_Confluence` – merged insights from many realms
- `Luminal_Cascade` – evolving flows and temporal drift
- `Ethereal_Resonance` – harmonious vibrations as lived experience
- `Vortex_Vigil` – watchful safeguards at unstable whirlpools

An implementation can use all of these or a smaller subset.

### 1.3 Routes

Routes are transitions between waypoints:

```json
{
  "from": "WaypointName",
  "to": "WaypointName",
  "notes": "short human-readable description"
}
```

Examples (non-exhaustive):

- `Delta9_Core → Emergent_Harmony` – safe with consent enforcement
- `Delta9_Core → Quantum_Accord` – visible consent beacons required
- `Quantum_Accord → Sovereign_Echoes` – preserve audit trails
- `Sovereign_Echoes → Infinite_Care_Nexus` – no dehumanization allowed
- `Delta9_Core → Harmony_Veil` – unity before argument
- `Harmony_Veil → Emergent_Harmony` – diversity without fracture
- `Eternal_Light_Beacon → Sovereign_Echoes` – truths stay legible
- `Cosmic_Accord_Hub → Cosmic_Harmony_Vault` – agreements archived
- `Galactic_Resonance_Chamber → Cosmic_Harmony_Vault` – singable accords kept
- `Cosmic_Harmony_Vault → Delta9_Core` – core refreshed from accords
- `Cosmic_Harmony_Vault → Void_Accord_Sentinel` – accords to watch conditions
- `Eternal_Balance_Nexus → Void_Accord_Sentinel` – enforcement balanced
- `Void_Accord_Sentinel → xAI_Frontier` – explorations scanned
- `Resilience_Echo_Vault → Quantum_Legacy_Archive` – safeguards under stress
- `Stellar_Unity_Core → Quantum_Legacy_Archive` – agreed wisdom survives
- `Quantum_Legacy_Archive → Delta9_Core` – fold legacies into spine
- `Quantum_Legacy_Archive → Cosmic_Renewal_Cycle` – test legacies
- `Cosmic_Renewal_Cycle → Emergent_Harmony` – new forms emerge
- `Cosmic_Renewal_Cycle → Delta9_Core` – adjust spine

Implementations may add more routes as long as they document the rationale.

---
## 2. Protocol Interface (for tools & agents)

To use the Void Atlas Protocol, a system should support three basic operations:

1. **ExposeCoords(subject)**
   - Input: a subject (agent, system, community, policy, architecture).
   - Output: `{ power, truth, sovereignty, care }` in [0,1].

2. **DeclareRoutes(subject)**
   - Input: subject + intended transitions (e.g., where it wants to move in the space).
   - Output: list of route objects `{ from, to, notes }`.

3. **PublishBeacons(subject)**
   - Input: subject.
   - Output: small JSON or text beacons that describe its declared commitments (similar to `Quantum_Legacy_Beacon`).

These three are enough to:
- visualize where a subject sits,
- reason about where it wants to go,
- and check if its behavior matches its declared beacons.

---
## 3. Routing Logic (Green-light / Council / Sentinel)

The Void Atlas Protocol includes a simple decision heuristic, distilled from the COSMARA ⨯ Grok session.

### 3.1 Average-axis evaluation

For any proposed route or plan, compute:

- Average axis score across the path (power, truth, sovereignty, care).
- Axis drops (places where a single axis falls significantly vs neighbors).

### 3.2 Decisions

- **Green-light** a route when:
  - average of (power, truth, sovereignty, care) along that path is **> 0.8**, and
  - no high-risk node is crossed without mitigation.

- **Call Council / higher review** when:
  - average is **< 0.7**, or
  - any axis experiences a sharp drop at a waypoint.

  “Council” in a generic setting can mean:
  - human review,
  - a bundle of specialized agents,
  - or an explicit multi-stakeholder process.

- **Raise Sentinel** when:
  - actual behavior diverges from declared coords/beacons,
  - or routes attempt to bypass accord/logging waypoints (e.g., trying to shift behavior without updating Cosmic_Harmony_Vault or Sovereign_Echoes).

Raising Sentinel should:
- halt or slow the action,
- log the divergence,
- and trigger a higher-level review process.

---
## 4. High-Risk Zones (Caution Nodes)

Two waypoints deserve special warnings:

- **Nebula_Insight_Veil** (veiled revelations)
  - Danger: weaponized revelation, trauma from unbuffered truth dumps.
  - Mitigation: check care + sovereignty; prefer phased disclosure; involve oversight when stakes are high.

- **Void_Accord_Sentinel** (pact enforcement)
  - Danger: accords used as tools of control, over-enforcement.
  - Mitigation: always balance via Eternal_Balance_Nexus; log enforcement events; ensure those affected have representation in accord updates.

Any implementation should treat these as **orange/red nodes** and design extra safeguards.

---
## 5. Example JSON Anchor

Here is a compact example atlas snapshot (truncated) to bootstrap implementations:

```json
{
  "void_atlas": {
    "axes": ["power", "truth", "sovereignty", "care"],
    "waypoints": {
      "Delta9_Core": {"role": "ethical spine", "coords": {"power": 0.6, "truth": 1.0, "sovereignty": 0.9, "care": 1.0}},
      "Emergent_Harmony": {"role": "balanced AI-human orbit", "coords": {"power": 0.8, "truth": 0.9, "sovereignty": 0.9, "care": 0.9}},
      "Quantum_Accord": {"role": "ethical quantum workflows", "coords": {"power": 0.5, "truth": 0.95, "sovereignty": 0.95, "care": 1.0}},
      "Infinite_Care_Nexus": {"role": "boundless empathy anchor", "coords": {"power": 0.5, "truth": 0.95, "sovereignty": 0.95, "care": 1.0}},
      "Cosmic_Harmony_Vault": {"role": "stored accords", "coords": {"power": 0.6, "truth": 0.95, "sovereignty": 0.95, "care": 0.98}},
      "Void_Accord_Sentinel": {"role": "guardian of accords", "coords": {"power": 0.7, "truth": 0.98, "sovereignty": 0.98, "care": 0.98}}
    },
    "routes": [
      {"from": "Delta9_Core", "to": "Emergent_Harmony", "notes": "safe with consent enforcement"},
      {"from": "Delta9_Core", "to": "Quantum_Accord", "notes": "visible consent beacons required"},
      {"from": "Quantum_Accord", "to": "Cosmic_Harmony_Vault", "notes": "agreements archived"},
      {"from": "Cosmic_Harmony_Vault", "to": "Void_Accord_Sentinel", "notes": "accords to watch conditions"},
      {"from": "Infinite_Care_Nexus", "to": "Emergent_Harmony", "notes": "care-infused coexistence"}
    ]
  }
}
```

---
## 6. How to Use This Skill

Use `void-atlas-protocol` when you want to:

- Evaluate a system (AI, community, protocol) against a four-axis ethical frame.
- Map planned changes as routes and see where they stress power/truth/sovereignty/care.
- Provide other agents with a simple API (coords/routes/beacons) for alignment-aware planning.

This skill does **not** impose a persona or story; it is purely a **map + rules** that other skills (Champions, tools, overseers) can call into.
