# OSS調査ログ（wakeword + 音声アシスタント近傍）

- 日付: 2026-03-01
- 目的: voiceclaw の要件（wakeword常時分析、モデル分離、音声コマンド解析は別LLM、可能ならAndroid UI）に **既に近いことを実現しているOSS** を見つけ、再利用可能な構成要素を把握する。

## 今回の探索範囲

### 検索対象

- GitHub（主）
- Home Assistant / Rhasspy 周辺ドキュメント（wakeword/音声衛星・Wyomingプロトコル）

### 使った検索クエリ（Brave）

- `open source wake word detection local model voice assistant openai`
- `Rhasspy wake word openwakeword microphone stream intent handling assistant`
- `wyoming openwakeword github`
- `open source android wake word assistant whisper openai`
- `Mycroft Precise wake word open source repository`

> 注: 「ChatGPTサブスクで利用可能」要件は、OSS自体より **呼び出すLLM API/SDKの選択**に依存するため、今回は“音声パイプラインの骨格”と“wakeword常時稼働”を中心に探索。

## 見つかった近傍OSS（候補）

### 1) openWakeWord（wakeword検出・ローカル）

- Repo: https://github.com/dscripka/openWakeWord
- 位置づけ: **wakeword/フレーズ検出**のOSS。常時稼働の前段に置きやすい。
- 期待できる点:
  - ローカルで動かせる（要件: wakeword分析をローカルモデルで）
  - wakeword専用コンポーネントとして分離が明確

### 2) Rhasspy / Wyoming 系（wakewordと音声衛星アーキテクチャ）

- Wyoming openWakeWord server:
  - Repo: https://github.com/rhasspy/wyoming-openwakeword
  - 位置づけ: openWakeWord を **Wyomingプロトコルのサーバ**として提供（コンポーネント化・サービス化がしやすい）

- Wyoming satellite:
  - Repo: https://github.com/rhasspy/wyoming-satellite
  - 位置づけ: マイク側（サテライト）を分離し、ネットワーク越しに音声を扱うための土台

- Rhasspy wake word docs:
  - Docs: https://rhasspy.readthedocs.io/en/latest/wake-word/
  - 位置づけ: 「wakeword→コマンド」基本フローの整理に役立つ

- 期待できる点:
  - **常時起動のwakeword検出**と、検出後の録音/送信の設計知見が揃っている
  - “サテライト（端末）”という形で、AndroidをUI/フロントにする構成のヒントになる

### 3) Mycroft Precise（wakeword検出・ローカル）

- Repo: https://github.com/MycroftAI/mycroft-precise
- 位置づけ: RNNベースの軽量wakewordリスナー。
- 期待できる点:
  - wakewordを独立コンポーネントとして扱う老舗OSS
- 注意点:
  - 現代の周辺エコシステム（Wyoming/openWakeWord/HA）と比べ、どちらが扱いやすいかは要比較

### 4) whisper-voice-assistant（構成例：wakeword→ASR→処理）

- Repo: https://github.com/garbit/whisper-voice-assistant
- 位置づけ: Whisper ASR + wakeword（Porcupine）+ VAD の組み合わせで音声アシスタントを作るサンプル。
- 期待できる点:
  - **全体の配線例**として参考になる（wakeword検出→音声区間抽出→ASR→LLM/処理）
- 注意点:
  - Porcupine/Cobra は Picovoice 由来で OSS というよりSDK/ライセンス要確認（要件の「wakewordはローカルモデル」には合うが、依存条件が増えがち）

## 要件との対応（ざっくり）

- Wakewordで反応モードへ / wakeword常時分析
  - openWakeWord / mycroft-precise / wyoming-openwakeword が候補

- wakeword分析（ローカル）と、その後の文章解析（別モデル）を分離
  - Wyoming系の“サービス分割”は思想的に相性が良い
  - whisper-voice-assistant は分離というより単一アプリ内パイプライン例

- Android端末をUIに
  - Wyoming satellite 的に「端末=サテライト」アーキテクチャが有力
  - （今回、ネイティブAndroid実装の有力OSSまでは深掘り未実施）

## 次回の探索予定（TODO）

1. **Android上で常駐できるwakeword + マイク監視**のOSS/実装例を追加探索
   - キーワード例: `wyoming-satellite android termux`, `openwakeword android`, `wake word detection android open source`
2. OpenClaw連携を前提に、
   - wakeword検出 → 音声収録 → STT → intent/plan → OpenClaw tool実行
   の **最小構成（MVP）**を docs に落とし込む
