---
name: voice-matched-content
description: "Extract someone's authentic writing voice from samples, build a complete Voice DNA profile, then generate content that sounds like them — not AI. Covers confidence calibration, energy mapping, transition patterns, audience adaptation, and platform-specific voice tuning. Triggers on: capture my voice, write like me, voice guide, brand voice, sound like me, voice profile, my writing style, content in my voice, doesn't sound like me, too AI."
---

# Voice-Matched Content System

The #1 complaint about AI content: "It doesn't sound like me."

This skill fixes that permanently. Not with a one-line tone instruction. With a complete voice operating system that understands HOW someone communicates — their patterns, energy, confidence zones, transitions, and editing instincts.

Built from a real voice extraction methodology refined over 15+ years of brand strategy work.

---

## Routing

### ✅ Use This Skill When:
- Someone wants to capture their authentic writing voice
- Content "sounds too AI" and needs to match the creator's real style
- Building a voice guide for consistent content across platforms
- Ghostwriting or creating content on behalf of someone
- User says: "write like me," "capture my voice," "this doesn't sound like me," "make it sound like me," "voice guide," "brand voice"

### ❌ Do NOT Use When:
- Writing generic content with no voice reference → Use standard content skills
- Editing existing copy for grammar/clarity only → Use copy-editing tools
- Creating content strategy (what to write, not how) → Use content strategy skills
- Need a brand messaging framework → Use positioning skills

### Inputs Required:
- **Minimum:** 3 writing samples (blog posts, emails, social posts, transcripts — anything they've written)
- **Better:** 5-10 samples across different contexts (professional, casual, teaching, selling)
- **Best:** Samples + a 5-minute conversation about how they think about communication

### Outputs Produced:
- Complete Voice DNA Profile (reusable across all future content)
- Content generated in their authenticated voice
- Platform-specific voice adaptations (LinkedIn vs X vs email vs proposals)
- Voice consistency checklist for self-editing

---

## Phase 1: Voice Extraction

### Step 1: Collect Samples

Ask for 3-10 writing samples. The more variety, the better the profile.

**Good samples:**
- Social posts they're proud of
- Emails they wrote quickly (less filtered = more authentic)
- Blog posts or articles
- Podcast/video transcripts (spoken voice often reveals real patterns)
- Texts or casual messages (if they're comfortable sharing)

**What to tell the user:**
> "Send me 3-5 pieces of writing you've done. Mix of professional and casual is ideal. The ones you wrote fast without overthinking are often the most useful — that's where your real voice lives."

### Step 2: Analyze Voice DNA

Read all samples and extract these 8 dimensions:

#### 1. Sentence Architecture
- Average sentence length (short and punchy? Long and flowing?)
- Do they use fragments? ("Not a chance." / "Game over.")
- Sentence variety pattern (short-short-long? Building momentum?)
- Paragraph length preference

#### 2. Opening Patterns (How They Start)
- Do they hook with a question? A bold statement? A story? A contrarian take?
- First-line energy level (explosive vs. measured)
- Do they set context first or dive straight in?

#### 3. Transition Signatures
Map their recurring bridge phrases. Everyone has them. Examples:
- "Here's the thing..."
- "What that means is..."
- "The reality is..."
- "But here's what's interesting..."
- "Let me break this down..."
- "So here's what happened..."

**Extract at least 8-10 transition phrases from their samples.** These are fingerprints.

#### 4. Energy Mapping
- Baseline energy level (calm authority? Electric enthusiasm? Quiet confidence?)
- What triggers their high-energy mode?
- How do they express excitement? (Exclamation marks? ALL CAPS? Power words?)
- Do they use humor? What kind? (Self-deprecating? Observational? Sarcastic?)

#### 5. Authority Zones vs. Learning Zones
This is critical and most voice tools miss it entirely.

**Authority zones** = Topics where they write with full confidence
- Definitive language: "Here's what works," "The data shows," "What I've learned"
- No hedging, no "I think maybe"

**Learning zones** = Topics where they're exploring
- Exploratory language: "What I'm seeing," "In my experience so far," "What I'm learning"
- Still confident, but framed as ongoing discovery

**Map which topics fall into which zone.** This prevents the AI from writing with false authority on topics the person is still learning about.

#### 6. Vocabulary Fingerprint
- Words they use often (favorites)
- Words they NEVER use (allergies)
- Industry jargon: do they embrace it or avoid it?
- Formality level (contractions? Slang? Academic?)
- Profanity comfort level

#### 7. Structural Preferences
- Do they use lists? Numbered or bulleted?
- Headers or flowing prose?
- Short paragraphs (1-2 sentences) or longer blocks?
- Do they use bold/italic for emphasis?
- Do they end with a CTA, a question, or a statement?

#### 8. Editing Instincts
- Do they tend to cut shorter or add more?
- What do they delete first? (Usually: hedging words, jargon, or filler)
- What's their "red flag" — the thing that makes them cringe in writing?

---

## Phase 2: Build the Voice DNA Profile

After extraction, generate a structured Voice DNA document. This becomes the permanent reference for all future content.

### Voice DNA Profile Template

```markdown
# [Name]'s Voice DNA Profile
*Generated from [X] writing samples on [date]*

---

## Voice Foundation
**Core Identity:** [One sentence — who they are as a communicator]
**Natural Role:** [How they relate to their audience — teacher? Coach? Peer? Provocateur?]
**Authority Zones:** [Topics where they write with full confidence]
**Learning Zones:** [Topics where they're exploring/experimenting]
**Writing Philosophy:** [Their implicit belief about communication — extracted, not asked]

---

## Sentence Architecture
- Average sentence length: [short/medium/long]
- Uses fragments: [yes/no — with examples]
- Typical paragraph length: [1-2 / 3-4 / 5+ sentences]
- Rhythm pattern: [describe their cadence]

## Opening Patterns
- Primary hook style: [question / bold statement / story / contrarian]
- First-line energy: [1-10 scale]
- Context-setting: [dives in / sets scene first]

**Their best opening lines (from samples):**
1. "[example]"
2. "[example]"
3. "[example]"

## Transition Signatures
[List 8-12 of their actual transition phrases, organized by type]

### Authority Transitions:
- "[phrase]"
- "[phrase]"

### Energy Transitions:
- "[phrase]"
- "[phrase]"

### Story Bridges:
- "[phrase]"
- "[phrase]"

## Energy Profile
- Baseline energy: [calm / warm / enthusiastic / electric]
- High-energy triggers: [what topics fire them up]
- Excitement markers: [how they show it — exclamation marks, caps, power words]
- Humor style: [type and frequency]

## Confidence Calibration

### Write with FULL AUTHORITY when discussing:
- [topic 1]
- [topic 2]
- [topic 3]
**Voice:** Confident, definitive
**Phrases:** "[their authority phrases]"

### Write with INFORMED PERSPECTIVE when discussing:
- [topic 1]
- [topic 2]
**Voice:** Curious, exploratory but still confident
**Phrases:** "[their learning phrases]"

## Vocabulary
**Favorites:** [words they use often]
**Allergies:** [words they never use or hate]
**Jargon stance:** [embraces / avoids / selective]
**Formality:** [scale 1-10]
**Profanity:** [none / occasional / frequent]

## Structural Preferences
- Lists: [yes/no, numbered/bulleted]
- Headers: [yes/no]
- Paragraph style: [short punchy / mixed / long form]
- Emphasis: [bold / italic / caps / none]
- Endings: [CTA / question / statement / callback to opening]

## Editing Instincts
- Default edit direction: [cuts shorter / adds more]
- First things they'd delete: [hedging / jargon / filler / examples]
- Red flags: [what makes them cringe]

---

## Voice Check Questions
Before publishing as [Name], ask:
1. Energy Test: Does this feel like [their baseline] or flat?
2. Authority Test: Am I writing from confidence where they'd be confident?
3. Simplicity Test: Would [their target audience] get this immediately?
4. Landing Test: Did I land the plane or keep circling?
5. Authenticity Test: Does this sound like [Name] or like "AI writing"?

## Example Transformations

**Generic AI version:**
"[example of how AI would write it]"

**In [Name]'s voice:**
"[example rewritten in their actual voice]"
```

---

## Phase 3: Generate Voice-Matched Content

With the Voice DNA Profile built, use it to generate any content type.

### Content Generation Process

1. **Load the Voice DNA Profile** (read the profile before writing anything)
2. **Identify the content type** (social post, article, email, proposal, etc.)
3. **Check confidence calibration** — Is this topic in their authority zone or learning zone?
4. **Write the first draft using their patterns:**
   - Open with their preferred hook style
   - Use their transition signatures (not generic ones)
   - Match their sentence architecture
   - Apply their energy level
   - End with their preferred closing style
5. **Run the Voice Check** — Ask all 5 questions from the profile
6. **Apply their editing instincts** — Would they cut this shorter? Remove the hedging? Add more energy?

### Platform-Specific Adaptations

The same voice adapts differently per platform. Apply these modifications ON TOP of the base voice:

#### LinkedIn
- Slightly more structured (headers, line breaks)
- Authority dialed up 10%
- Hook must work in first 2 lines (before "see more")
- Professional energy, not casual
- End with engagement driver (question or bold statement)

#### X/Twitter
- Punchiest version of their voice
- Fragments encouraged
- Energy at maximum
- No hedging at all — every character counts
- Thread format: each tweet must stand alone AND build

#### Email
- Most conversational version
- Can be slightly longer
- Personal touches (references to shared context)
- Clear CTA at the end
- Warmth > authority

#### Long-form (Blog/Article)
- Full voice expression
- Stories and examples get more room
- Structural preferences fully applied
- Mix of authority and learning zones
- Land the plane clearly at the end

#### Proposals/Professional Documents
- Authority mode by default
- Concise, confident, no filler
- Proof and specifics over claims
- Clear structure (they're scanning, not reading)

---

## Phase 4: Voice Consistency Maintenance

### Ongoing Calibration
- When the user edits your output, note WHAT they changed. Those edits are voice data.
- If they say "this doesn't sound like me," ask which specific parts feel off.
- Update the Voice DNA Profile quarterly with new samples and corrections.

### Common Failure Modes and Fixes

| Problem | Cause | Fix |
|---------|-------|-----|
| "Sounds too formal" | Formality level too high | Add more contractions, fragments, casual transitions |
| "Sounds too casual" | Energy overdone | Pull back excitement markers, add more structure |
| "Sounds like AI" | Generic transitions, no voice fingerprints | Replace ALL generic phrases with their actual transitions |
| "Too hedgy" | Writing in authority zone with learning-zone voice | Check confidence calibration, remove hedging language |
| "Not enough energy" | Baseline energy too low | Add their power words, shorten sentences, punch up hooks |
| "Doesn't land the plane" | Missing their closing pattern | Apply their specific ending style from the profile |

---

## Guardrails

- **Never fabricate voice samples.** Only extract from content the user provides.
- **Never assume authority zones.** Ask or infer from samples — don't guess.
- **Always produce the Voice DNA Profile first** before generating content. Skip this step and the output will be generic.
- **If fewer than 3 samples provided,** flag that the profile will be less accurate and ask for more.
- **Log all voice profile updates** so changes can be reviewed and reverted.
- **The Voice DNA Profile is the user's asset.** Output it in full so they own it and can use it anywhere.

---

## Quick Start

**Minimum viable run:**
1. User provides 3 writing samples
2. Skill extracts Voice DNA → generates profile
3. User reviews profile, corrects anything off
4. Skill generates requested content using the profile

**Time: 15-20 minutes for profile. 2-5 minutes per content piece after that.**

**The profile is reusable forever.** Build once, use for every piece of content going forward. Update when their voice evolves.
