---
name: vocabulary-builder
description: Build and review vocabulary from books, podcasts, and daily encounters. Use when the user wants to READ a book, shares a new word, asks about a word while reading a book, requests a vocabulary quiz, asks about word progress, or when a cron/heartbeat triggers a scheduled quiz. Handles reading sessions, word collection, 3-step learning, spaced repetition, and progress tracking.
metadata: {"url": "https://youtu.be/wjWrVpZZXSg", "files": {"vocabFile": "memory/vocabulary.md", "audioDir": "docs/tts-fr"}}
---

# Vocabulary Builder

This skill reads and writes the following files (paths relative to workspace):
- **Vocabulary tracker:** `memory/vocabulary.md` — all word data lives here
- **Audio clips directory:** `docs/tts-fr/` — read-only; user places pronunciation audio files here

Ensure these paths exist or create them before first use.

## Reading Workflow

When the user wants to read/practice reading a book:
1. Ask what book they're reading
2. Check the vocabulary tracker for words from that book — read the END of the Active Words section (use `tail` or read the last entries) to find the actual last word. Note: `memory_search` may return partial/ranked results, so also verify by reading the file directly when checking the latest entry.
3. Tell them the last word added + page number so they know where to continue
4. Ask if they want to: practice pending words, or keep reading and add new ones

## Adding New Words

When the user gives a new word:

1. Give **pronunciation** (IPA, American English)
2. Give **meaning** — clear, simple
3. Give **synonyms** — similar words they might know
4. **Add to tracker** after confirming with the user (e.g., "Adding [word] to your vocabulary — ok?")
5. **Show the word card** after adding

Add to the `## Active Words` section, at the END (before `---` separator for Long-Term Review).

### Word Entry Format

```markdown
### [word]
- **Type:** noun/verb/adj/adv
- **Learned:** YYYY-MM-DD HH:MM TZ
- **Book:** [source name]
- **Page:** [number]
- **Pronunciation:** /IPA/
- **Meaning:** [explanation]
- **Synonyms:** [similar words]
- **Context:** "[sentence from source]"
- **Practice History:**
  - YYYY-MM-DD HH:MM TZ: Step N ✓/✗ (notes)
```

### French Words

- **Context:** French sentence only
- **English Translation:** Separate field with English translation
- Do NOT mix French and English in the same field
- User places audio clips in `docs/tts-fr/` → add **Audio** field with the file path

## 3-Step Learning Process

Run all 3 steps in one conversation flow (not spread across hours):

- **Step 1:** Show the plain word + review count (e.g. "reviewed 0 times" or "reviewed 3 times") → ask "Do you know the pronunciation?" → user types word to confirm
- **Step 2:** Ask "What does it mean?" → check if correct/close enough
- **Step 3:** Ask user to write a sentence using the word

Trust-based pronunciation — no voice/ASR check. User types word to confirm.

## Spaced Repetition Schedule

After completing all 3 steps, review at:
- Next day → 3 days → 1 week → 2 weeks → 1 month → 3 months
- After 3-month review: word is **mastered**

### Word Progression

Words move through three sections in the tracker:
1. **Active Words** — currently learning
2. **Long-Term Review Words** — completed all steps, in spaced review
3. **Mastered Words** — passed all reviews through 3 months

## Quiz Rules

- **One word per quiz** — no rapid-fire
- **No spam:** If no reply to previous quiz today → don't send new one
- **Reset next day:** New day = can send quiz even if yesterday's unanswered
- **Sleep hours:** No messages 11 PM – 7 AM (user's timezone)
- **Priority:** due for review > newer words (incomplete steps) > refresher

### Random Word Selection

1. Count each word's total practice history entries (all steps and reviews combined)
2. Sort all words by review count ascending (least reviewed first)
3. Take the group with the minimum review count
4. Within that group, randomize: count words (N), use `(current_timestamp_ms % N) + 1` to pick position
5. **Never pick the same word twice in a row.** Check Quiz State for the last quizzed word and skip it.

**Always show review count** when quizzing: e.g. "(reviewed 0 times)" or "(reviewed 3 times)".

### On-Demand Quizzes

User can request specific quizzes anytime — these override normal priority and spam rules:

- "Quiz me" → random word
- "Quiz me on [word]" → specific word
- "Quiz me on words from [book]" → random from that book
- "Quiz me on words from this week" → last 7 days
- "Quiz me on [book] page [N] to [M]" → page range
- "Give me 3 quizzes" → run 3 words in a row

On-demand refresher: If no words are due/pending, pick random word from all learned words. Still record quiz date.

## Quiz State Tracking

Keep a `## Quiz State` section at the top of the tracker file:

```markdown
## Quiz State
- **Pending quiz:** [word] ([review type], [step] sent)
- **Last quiz sent:** YYYY-MM-DD HH:MM TZ
```

Update after each quiz interaction.

## Cron Setup

When the user asks to set up a scheduled vocabulary quiz:

1. **Ask for:** frequency (default: every 1h), delivery channel + target
2. **Job name:** `vocabulary-quiz-{agentName}` (e.g. `vocabulary-quiz-english`)
3. **Create a cron job** with these settings:
   - Session: isolated
   - Timeout: 120 seconds
   - Message: instruct the agent to use the `vocabulary-builder` skill to run a quiz
4. **Quiz constraints** (include in the cron message):
   - Check Quiz State — skip if pending quiz unanswered today
   - Respect sleep hours: no messages 11PM–7AM (user's timezone)

## References

- Video: [Why I Stopped Using Flashcards and Started Using AI](https://youtu.be/wjWrVpZZXSg)
